#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

#include <TGFileDialog.h>
#include <TRootHelpDialog.h>

#include "TImage.h"
#include "TRecorder.h"

#include <TGClient.h>
#include <TGFrame.h>
#include <TGLayout.h>
#include <TGSplitter.h>

#include <TGLOverlayButton.h>

#include <TLatex.h>
#include <TVirtualFitter.h>

#include <TG3DLine.h>
#include <TAxis3D.h>
#include <TStyle.h>
#include <TLegend.h>
#include <TF1.h>
#include <TEveGValuators.h>
#include <TGDoubleSlider.h>

#include <TApplication.h>
#include <TEveManager.h>
#include <TEveEventManager.h>
#include <TEveWindowManager.h>
#include <TEveVSD.h>
#include <TEveVSDStructs.h>

#include <TCanvas.h>

#include <TEveTrack.h>
#include <TEveTrackPropagator.h>
#include <TEveGeoShape.h>

#include <TEveSelection.h>

#include <TGLEmbeddedViewer.h>
#include <TCanvas.h>
#include <TParticlePDG.h>

#include <TH1D.h>

#include <TGTextEntry.h>

#include <TGLabel.h>
#include <TGComboBox.h>

#include <TGTab.h>
#include <TGButton.h>
#include <TTimer.h>

#include <TFile.h>
#include <TKey.h>
#include <TSystem.h>
#include <TPRegexp.h>

#include <TGNumberEntry.h>
#include <TGLWidget.h>

#include <TFileMerger.h>
#include <TSystemDirectory.h>

#include "MultiView.C"

using namespace std;

namespace
{
  const char *gMasterClassOutputData[] = {"MasterClass Output Data", "*.masterclass", 0, 0}; //for loading results
}

namespace
{
  const char *gMasterClassOutputPictue[] = {"MasterClass Histograms", "*.png", 0, 0}; //for loading results
}

MultiView* gMultiView = 0;

TH1D* gKMinvHist = 0;
TH1D* gXMinvHist = 0;
TH1D* gLMinvHist = 0;
TH1D* gALMinvHist = 0;
TH1D* gAllMinvHist = 0;

TCanvas* pad1 = 0;
TCanvas* pad2 = 0;

TGCheckButton* gCheckVertex = 0;
TGCheckButton* gCheckClusters = 0;
TGCheckButton* gCheckITSClusters = 0;
TGCheckButton* gCheckTPCClusters = 0;
TGCheckButton* gCheckTRDClusters = 0;
TGCheckButton* gCheckTOFClusters = 0;
TGCheckButton* gCheckESDTracks = 0;
TGCheckButton* gCheckV0s = 0;
TGCheckButton* gCheckCascades = 0;

TGLabel* gEventNumber = 0;

TEveLine* pointingLine[10] = {0};
TEveLine* pointingLine1[10] = {0};
TEveLine* pointingLine2[10] = {0};
TEveLine* guideX[12] = {0};
TEveLine* guideY[14] = {0};
TEveLine* guideZ[14] = {0};

Int_t globalChoice = 0;
Int_t globalMode = 0;
Int_t globalDataset = 0;
Int_t gLoads = 0;

Int_t nV0Tracks = 0;
Int_t nCascadeTracks = 0;

Double_t pxPos[10] = {0};
Double_t pyPos[10] = {0};
Double_t pzPos[10] = {0};
Double_t massPos[10] = {0};

Double_t pxNeg[10] = {0};
Double_t pyNeg[10] = {0};
Double_t pzNeg[10] = {0};
Double_t massNeg[10] = {0};

Double_t pxPosCas[10] = {0};
Double_t pyPosCas[10] = {0};
Double_t pzPosCas[10] = {0};
Double_t massPosCas[10] = {0};

Double_t pxNegCas[10] = {0};
Double_t pyNegCas[10] = {0};
Double_t pzNegCas[10] = {0};
Double_t massNegCas[10] = {0};

Double_t pxBacCas[10] = {0};
Double_t pyBacCas[10] = {0};
Double_t pzBacCas[10] = {0};
Double_t massBacCas[10] = {0};
Double_t chargeBacCas[10] = {0};

Double_t pxPosFound = 0;
Double_t pyPosFound = 0;
Double_t pzPosFound = 0;
Double_t massPosFound = 0;

Double_t pxNegFound = 0;
Double_t pyNegFound = 0;
Double_t pzNegFound = 0;
Double_t massNegFound = 0;

Int_t chargeNegFound = -1;
Int_t chargePosFound = 1;

Bool_t foundNeg = kFALSE;
Bool_t foundPos = kFALSE;
Bool_t teacher = kFALSE;

Double_t pcaX[10] = {0};
Double_t pcaY[10] = {0};
Double_t pcaZ[10] = {0};

Double_t pcaXCas[10] = {0};
Double_t pcaYCas[10] = {0};
Double_t pcaZCas[10] = {0};

Double_t pcaXBacCas[10] = {0};
Double_t pcaYBacCas[10] = {0};
Double_t pcaZBacCas[10] = {0};

Int_t detector = 0;
Int_t geometry = 0;

Int_t AC = 0;

TString globalName1 = "";
TString globalName2 = "";

// Mass of particles in MeV
Double_t gMassElecton = 0.000510998910;
Double_t gMassMuon = 0.105658367;
Double_t gMassPion = 0.13957018;
Double_t gMassKaon = 0.493677;
Double_t gMassProton = 0.938272013;

Bool_t change = kTRUE;

//--------------------------------------------------------------
//additional classes
//--------------------------------------------------------------

class PatternsInfoWindow : public TGMainFrame
{

  TGPictureButton *b1;

public:

  PatternsInfoWindow(const TGWindow *p, UInt_t w, UInt_t h, Int_t particle=0) :
    TGMainFrame(p, w, h)
  {

    DontCallClose();

    b1 = 0;
    TGGroupFrame* groupFrame = 0;
    TGHorizontalFrame *hframe00 = 0;

    switch (particle)
      {
      case 0:
	groupFrame = new TGGroupFrame(this, "Kaon");
	hframe00 = new TGHorizontalFrame(groupFrame, 250, 250);
	b1 = new TGPictureButton(hframe00, gClient->GetPicture("eve_files/kaon.png"));
	SetWindowName("Kaon Pattern");
	break;

      case 1:
	groupFrame = new TGGroupFrame(this, "Lambda");
	hframe00 = new TGHorizontalFrame(groupFrame, 250, 250);
	b1 = new TGPictureButton(hframe00, gClient->GetPicture("eve_files/lambda.png"));
	SetWindowName("Lambda Pattern");
	break;

      case 2:
	groupFrame = new TGGroupFrame(this, "AntiLambda");
	hframe00 = new TGHorizontalFrame(groupFrame, 250, 250);
	b1 = new TGPictureButton(hframe00, gClient->GetPicture("eve_files/antilambda.png"));
	SetWindowName("AntiLambda Pattern");
	break;

      case 3:
	groupFrame = new TGGroupFrame(this, "Phi");
	hframe00 = new TGHorizontalFrame(groupFrame, 250, 250);
	b1 = new TGPictureButton(hframe00, gClient->GetPicture("eve_files/xi.png"));
	SetWindowName("Xi Pattern");
	break;

      default:
	groupFrame = new TGGroupFrame(this, "Kaon");
	hframe00 = new TGHorizontalFrame(groupFrame, 250, 250);
	b1 = new TGPictureButton(hframe00, gClient->GetPicture("eve_files/kaon.png"));
	SetWindowName("Kaon Pattern");
	break;
      }

    b1->Connect("Clicked()", "PatternsInfoWindow", this, "UnmapWindow()");

    hframe00->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    groupFrame->AddFrame(hframe00);

    AddFrame(groupFrame);

    MapSubwindows();

    Resize(GetDefaultSize());

    MapWindow();

  }

  ClassDef(PatternsInfoWindow, 0);

};

PatternsInfoWindow* gPatternsInfoWindow = 0;

class AlicePatternInfo : public TGMainFrame
{

protected:

  TGPictureButton *b1;

public:

  AlicePatternInfo(const TGWindow *p, UInt_t w, UInt_t h) :
    TGMainFrame(p, w, h)
  {

    DontCallClose();

    b1 = 0;

    TGTextButton *b2 = 0;

    TGGroupFrame* gf = new TGGroupFrame(this, "Patterns");

    TGHorizontalFrame *hf = new TGHorizontalFrame(gf, 250, 250);

    b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/kaon_small.png"));

    b1->Connect("Clicked()", "AlicePatternInfo", this, "MakeBigger()");

    hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    gf->AddFrame(hf);

    hf = new TGHorizontalFrame(gf);
    {

      b2 = new TGTextButton(hf, "Kaon");
      b2->Connect("Clicked()", "AlicePatternInfo", this, "ShowALICE()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "Lambda");
      b2->Connect("Clicked()", "AlicePatternInfo", this, "ShowITS()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "AntiLambda");
      b2->Connect("Clicked()", "AlicePatternInfo", this, "ShowTPC()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "Xi");
      b2->Connect("Clicked()", "AlicePatternInfo", this, "ShowTRDTOF()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    }

    gf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    hf = new TGHorizontalFrame(gf);
    {

      b2 = new TGTextButton(hf, "Close");
      b2->Connect("Clicked()", "AlicePatternInfo", this, "UnmapWindow()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    }

    gf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    AddFrame(gf);

    SetWindowName("Pattern Info");
    MapSubwindows();

    // Initialize the layout algorithm via Resize()
    Resize(GetDefaultSize());

    // Map main frame
    MapWindow();

  }

  void ShowALICE()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/kaon_small.png"));
    b1->DoRedraw();

    detector = 0;

  }

  void ShowITS()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/lambda_small.png"));
    b1->DoRedraw();

    detector = 1;

  }

  void ShowTPC()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/antilambda_small.png"));
    b1->DoRedraw();

    detector = 2;

  }

  void ShowTRDTOF()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/xi_small.png"));
    b1->DoRedraw();

    detector = 3;

  }

  void MakeBigger()
  {

    gPatternsInfoWindow = new PatternsInfoWindow(gClient->GetRoot(),100,100, detector);

  }

  ClassDef(AlicePatternInfo, 0);

};

AlicePatternInfo* gAlicePatternInfo = 0;

class AliceDetectorInfoWindow : public TGMainFrame
{

  TGPictureButton *b1;

public:

  AliceDetectorInfoWindow(const TGWindow *p, UInt_t w, UInt_t h, Int_t detector_info=0) :
    TGMainFrame(p, w, h)
  {

    DontCallClose();

    b1 = 0;

    TGGroupFrame* gf = 0;
    TGHorizontalFrame *hf = 0;

    switch (detector_info)
      {
      case 0:
	gf = new TGGroupFrame(this, "ALICE Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/ALICE.png"));
	SetWindowName("ALICE Detector Info");
	break;

      case 1:
	gf = new TGGroupFrame(this, "ITS Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/ITS.png"));
	SetWindowName("ITS Detector Info");
	break;

      case 2:
	gf = new TGGroupFrame(this, "TPC Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/TPC.png"));
	SetWindowName("TPC Detector Info");
	break;

      case 3:
	gf = new TGGroupFrame(this, "TRD and TOF Detectors");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/TRDTOF.png"));
	SetWindowName("TRD and TOF Detectors Info");
	break;

      case 4:
	gf = new TGGroupFrame(this, "PHOS Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/PHOS.png"));
	SetWindowName("PHOS Detector Info");
	break;

      case 5:
	gf = new TGGroupFrame(this, "HMPID Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/HMPID.png"));
	SetWindowName("HMPID Detector Info");
	break;

      default:
	gf = new TGGroupFrame(this, "ALICE Detector");
	hf = new TGHorizontalFrame(gf, 250, 250);
	b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/ALICE.png"));
	SetWindowName("ALICE Detector Info");
	break;
      }

    b1->Connect("Clicked()", "AliceDetectorInfoWindow", this, "UnmapWindow()");

    hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    gf->AddFrame(hf);

    AddFrame(gf);

    MapSubwindows();

    Resize(GetDefaultSize());

    MapWindow();

  }

  ClassDef(AliceDetectorInfoWindow, 0);

};

AliceDetectorInfoWindow* gAliceDetectorInfoWindow = 0;

class AliceDetectorInfo : public TGMainFrame
{

protected:

  TGPictureButton *b1;

public:

  AliceDetectorInfo(const TGWindow *p, UInt_t w, UInt_t h) :
    TGMainFrame(p, w, h)
  {

    DontCallClose();

    b1 = 0;

    TGTextButton *b2 = 0;

    TGGroupFrame* gf = new TGGroupFrame(this, "ALICE Detector");

    TGHorizontalFrame *hf = new TGHorizontalFrame(gf, 250, 250);

    b1 = new TGPictureButton(hf, gClient->GetPicture("eve_files/ALICE_small2.png"));

    b1->Connect("Clicked()", "AliceDetectorInfo", this, "MakeBigger()");

    hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    gf->AddFrame(hf);

    hf = new TGHorizontalFrame(gf);
    {

      b2 = new TGTextButton(hf, "ALICE");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowALICE()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "ITS");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowITS()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "TPC");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowTPC()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "TRD+TOF");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowTRDTOF()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "PHOS");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowPHOS()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b2 = new TGTextButton(hf, "HMPID");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "ShowHMPID()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    }

    gf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    hf = new TGHorizontalFrame(gf);
    {

      b2 = new TGTextButton(hf, "Close");
      b2->Connect("Clicked()", "AliceDetectorInfo", this, "UnmapWindow()");
      hf->AddFrame(b2, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

    }

    gf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    AddFrame(gf);

    SetWindowName("ALICE Detector Info");
    MapSubwindows();

    // Initialize the layout algorithm via Resize()
    Resize(GetDefaultSize());

    // Map main frame
    MapWindow();

  }

  void ShowALICE()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/ALICE_small2.png"));
    b1->DoRedraw();

    detector = 0;

  }

  void ShowITS()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/ITS_small.png"));
    b1->DoRedraw();

    detector = 1;

  }

  void ShowTPC()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/TPC_small.png"));
    b1->DoRedraw();

    detector = 2;

  }

  void ShowTRDTOF()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/TRDTOF_small.png"));
    b1->DoRedraw();

    detector = 3;

  }

  void ShowPHOS()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/PHOS_small.png"));
    b1->DoRedraw();

    detector = 4;

  }

  void ShowHMPID()
  {

    b1->SetPicture(gClient->GetPicture("eve_files/HMPID_small.png"));
    b1->DoRedraw();

    detector = 5;

  }

  void MakeBigger()
  {

    gAliceDetectorInfoWindow = new AliceDetectorInfoWindow(gClient->GetRoot(),100,100, detector);

  }


  ClassDef(AliceDetectorInfo, 0);

};

AliceDetectorInfo* gAliceDetectorInfo = 0;


//---------------------------------------------------------------------------


class TVSDReader
{
public:
  // ----------------------------------------------------------
  // File / Event Data
  // ----------------------------------------------------------

  TFile      *fFile;
  TDirectory *fDirectory;

  TObjArray  *fEvDirKeys;

  TEveVSD    *fVSD;

  Int_t       fMaxEv, fCurEv, fMaxR, fRAnim, fAnalysis1, fAnalysis2;

  Bool_t      fVertexLoaded, fITSClustersLoaded, fTPCClustersLoaded, fTRDClustersLoaded, fTOFClustersLoaded,  fClustersLoaded, fEsdTracksLoaded, fV0sLoaded, fCascadesLoaded, fGuidesLoaded, fGeometrySet, fInDemoMode;

  // ----------------------------------------------------------
  // Event visualization structures
  // ----------------------------------------------------------

  TEveTrackList *fTrackList;
  TEveTrackList *fTrackListV0Neg;
  TEveTrackList *fTrackListV0Pos;
  TEveTrackList *fTrackListV0Mother;
  TEveTrackList *fTrackListCascade;
  TEveTrackList *fTrackListCascadeNeg;
  TEveTrackList *fTrackListCascadePos;
  TEveTrackList *fTrackListCascadeBachelor;
  TEveTrackList *fTrackListCascadeMother;
  TEveTrackList *fTrackListPointingV0;

  TEvePointSet  *fPsVertex;
  TEvePointSet  *fITSClusters;
  TEvePointSet  *fTPCClusters;
  TEvePointSet  *fTRDClusters;
  TEvePointSet  *fTOFClusters;
  TEvePointSet  *fPsV0;
  TEvePointSet  *fPsCascade;

  TTimer        *fTimer;

  TGLOverlayButton*	obutton1;
  TGLOverlayButton*	obutton2;
  TGLOverlayButton*	obutton3;
  TGLOverlayButton*	overlayButton;

  TGTextEntry*		fAnalysis1TE;
  TGTextEntry*		fAnalysis2TE;

  TH1D*			fMinvHisto;
  TCanvas*		fPad;
  TEveGDoubleValuator*	fFitRangeGaus;
  TEveGDoubleValuator*	fFitRangePoly;
  TGPictureButton*	fResultButton1;
  TGPictureButton*	fResultButton2;
  TGPictureButton*	fResultButton3;
  TGPictureButton*	fResultButton4;
  TGPictureButton*	fResultButton5;
  TGPictureButton*	fResultButton6;
  TGPictureButton*	fResultButton7;
  TGPictureButton*	fResultButton8;
  TString		fResultPicture1;
  TString		fResultPicture2;
  TString		fResultPicture3;
  TString		fResultPicture4;
  TString		fResultPicture5;
  TString		fResultPicture6;
  TString		fResultPicture7;
  TString		fResultPicture8;
  TF1*			fFitGaus;
  TF1*			fFitPolynomial;
  TGComboBox*           fSaveDir;
  TGComboBox*           fLoadDir;
  TGTextEntry*          fTeacherName;

public:
  TVSDReader(const char* file_name) :
    fFile(0), fDirectory(0), fEvDirKeys(0),
    fVSD(0),

    fMaxEv(-1), fCurEv(-1), fMaxR(400), fRAnim(0), fAnalysis1(0), fAnalysis2(0),

    fVertexLoaded(kTRUE), fITSClustersLoaded(kFALSE), fTPCClustersLoaded(kFALSE), fTRDClustersLoaded(kFALSE),
    fTOFClustersLoaded(kFALSE), fClustersLoaded(kTRUE), fEsdTracksLoaded(kTRUE), fV0sLoaded(kFALSE), fCascadesLoaded(kFALSE), fGuidesLoaded(kFALSE),
    fGeometrySet(kTRUE), fInDemoMode(kFALSE),

    fTrackList(0), fTrackListV0Neg(0), fTrackListV0Pos(0), fTrackListV0Mother(0),
    fTrackListCascade(0), fTrackListCascadeNeg(0), fTrackListCascadePos(0), fTrackListCascadeBachelor(0), fTrackListCascadeMother(0),
    fTrackListPointingV0(0),
    fPsVertex(0), fITSClusters(0), fTPCClusters(0), fTRDClusters(0), fTOFClusters(0),
    fPsV0(0), fPsCascade(0), fTimer(0),
    obutton1(0), obutton2(0), obutton3(0), overlayButton(0),
    fAnalysis1TE(0), fAnalysis2TE(0), fMinvHisto(0), fPad(0), fFitRangeGaus(0), fFitRangePoly(0),
    fResultButton1(0), fResultButton2(0), fResultButton3(0), fResultButton4(0), 
    fResultButton5(0), fResultButton6(0), fResultButton7(0), fResultButton8(0),
    fResultPicture1(0), fResultPicture2(0), fResultPicture3(0), fResultPicture4(0),
    fResultPicture5(0), fResultPicture6(0), fResultPicture7(0), fResultPicture8(0),
    fFitGaus(0), fFitPolynomial(0), fSaveDir(0), fLoadDir(0), fTeacherName(0)

  {
    fFile = TFile::Open(file_name);
    if (!fFile)
      {
	Error("VSD_Reader", "Can not open file '%s' ... terminating.", file_name);
	gSystem->Exit(1);
      }

    fEvDirKeys = new TObjArray;
    TPMERegexp name_re("Event\\d+");
    TObjLink* lnk = fFile->GetListOfKeys()->FirstLink();
    while (lnk)
      {
	if (name_re.Match(lnk->GetObject()->GetName()))
	  {
            fEvDirKeys->Add(lnk->GetObject());
	  }
	lnk = lnk->Next();
      }

    fMaxEv = fEvDirKeys->GetEntriesFast();
    if (fMaxEv == 0)
      {
	Error("VSD_Reader", "No events to show ... terminating.");
	gSystem->Exit(1);
      }

    fVSD = new TEveVSD;

    if(gMultiView)
      {
	obutton1 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "use ROLLER to zoom in/out", 0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-20, 250, 20);
	obutton2 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "click LEFT button to rotate", 0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-40, 250, 20);
	obutton3 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "press ROLLER to move", 0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-60, 250, 20);
      }
    else
      {
	obutton1 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "use ROLLER to zoom in/out", 0, 0, 250, 20);
	obutton2 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "click LEFT button to rotate", 0, 0, 250, 20);
	obutton3 = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "press ROLLER to move", 0, 0, 250, 20);
      }

    obutton1->SetAlphaValues(0.05, 0.8);
    obutton2->SetAlphaValues(0.05, 0.8);
    obutton3->SetAlphaValues(0.05, 0.8);

  }

  virtual ~TVSDReader()
  {
    // Destructor.

    DropEvent();

    delete fVSD;
    delete fEvDirKeys;

    fFile->Close();
    delete fFile;
  }

  void ToTeacher(){

    DropEvent();

    fInDemoMode = kFALSE;

    delete fVSD;
    delete fEvDirKeys;

    fFile->Close();
    delete fFile;

    fFile = TFile::Open("eve_files/data/AliVSD_teacher.root");
    if (!fFile)
      {
	Error("VSD_Reader", "Can not open the file ... terminating.");
	gSystem->Exit(1);
      }

    fEvDirKeys = new TObjArray;
    TPMERegexp name_re("Event\\d+");
    TObjLink* lnk = fFile->GetListOfKeys()->FirstLink();
    while (lnk)
      {
	if (name_re.Match(lnk->GetObject()->GetName()))
	  {
            fEvDirKeys->Add(lnk->GetObject());
	  }
	lnk = lnk->Next();
      }

    fMaxEv = fEvDirKeys->GetEntriesFast();
    if (fMaxEv == 0)
      {
	Error("VSD_Reader", "No events to show ... terminating.");
	gSystem->Exit(1);
      }

    fVSD = new TEveVSD;
    fTimer = new TTimer();
    fTimer->Connect("Timeout()", "TVSDReader", this, "AnimateEsdTracks()");

    globalChoice = 2;
    globalMode = 3;

    fInDemoMode = kFALSE;

    fVertexLoaded = kFALSE;
    fITSClustersLoaded = kFALSE;
    fTPCClustersLoaded = kFALSE;
    fTRDClustersLoaded = kFALSE;
    fTOFClustersLoaded = kFALSE;
    fClustersLoaded = kFALSE;
    fEsdTracksLoaded = kTRUE;
    fV0sLoaded = kFALSE;
    fCascadesLoaded = kFALSE;
    fGuidesLoaded = kFALSE;
    fGeometrySet = kTRUE;

    TeacherSet();

    GotoEvent(0);

  }

  void ToDemo(){

    DropEvent();

    fInDemoMode = kTRUE;

    globalChoice = 1;
    globalMode = 1;

    delete fVSD;
    delete fEvDirKeys;

    fFile->Close();
    delete fFile;

    fFile = TFile::Open("eve_files/data/AliVSD_example.root");
    if (!fFile)
      {
	Error("VSD_Reader", "Can not open the demo file ... terminating.");
	gSystem->Exit(1);
      }

    fEvDirKeys = new TObjArray;
    TPMERegexp name_re("Event\\d+");
    TObjLink* lnk = fFile->GetListOfKeys()->FirstLink();
    while (lnk)
      {
	if (name_re.Match(lnk->GetObject()->GetName()))
	  {
            fEvDirKeys->Add(lnk->GetObject());
	  }
	lnk = lnk->Next();
      }

    fMaxEv = fEvDirKeys->GetEntriesFast();
    if (fMaxEv == 0)
      {
	Error("VSD_Reader", "No events to show ... terminating.");
	gSystem->Exit(1);
      }


    fVertexLoaded = kFALSE;
    fITSClustersLoaded = kFALSE;
    fTPCClustersLoaded = kFALSE;
    fTRDClustersLoaded = kFALSE;
    fTOFClustersLoaded = kFALSE;
    fClustersLoaded = kFALSE;
    fEsdTracksLoaded = kFALSE;
    fV0sLoaded = kFALSE;
    fCascadesLoaded = kFALSE;
    fGuidesLoaded = kFALSE;
    fGeometrySet = kTRUE;


    fVSD = new TEveVSD;
    fTimer = new TTimer();
    fTimer->Connect("Timeout()", "TVSDReader", this, "AnimateEsdTracks()");

//    StudentSet();

    GotoEvent(0);

    gEve->FullRedraw3D();
      
  }

  void ToStudent(){

    DropEvent();

    fInDemoMode = kFALSE;

    globalChoice = 2;
    globalMode = 2;

    delete fVSD;
    delete fEvDirKeys;

    fFile->Close();
    delete fFile;

    switch(globalDataset)
    {

    case 1:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_1.root");
      break;

    case 2:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_2.root");
      break;

    case 3:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_3.root");
      break;

    case 4:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_4.root");
      break;

    case 5:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_5.root");
      break;

    case 6:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_6.root");
      break;

    case 7:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_7.root");
      break;

    case 8:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_8.root");
      break;


    default:
      fFile = TFile::Open("eve_files/data/AliVSD_MasterClass_1.root");
      break;

    }
//    fFile = TFile::Open("AliVSD.root");

    if (!fFile)
      {
	Error("VSD_Reader", "Can not open the demo file ... terminating.");
	gSystem->Exit(1);
      }

    fEvDirKeys = new TObjArray;
    TPMERegexp name_re("Event\\d+");
    TObjLink* lnk = fFile->GetListOfKeys()->FirstLink();
    while (lnk)
      {
	if (name_re.Match(lnk->GetObject()->GetName()))
	  {
            fEvDirKeys->Add(lnk->GetObject());
	  }
	lnk = lnk->Next();
      }

    fMaxEv = fEvDirKeys->GetEntriesFast();
    if (fMaxEv == 0)
      {
	Error("VSD_Reader", "No events to show ... terminating.");
	gSystem->Exit(1);
      }

    fVertexLoaded = kFALSE;
    fITSClustersLoaded = kFALSE;
    fTPCClustersLoaded = kFALSE;
    fTRDClustersLoaded = kFALSE;
    fTOFClustersLoaded = kFALSE;
    fClustersLoaded = kFALSE;
    fEsdTracksLoaded = kTRUE;
    fV0sLoaded = kFALSE;
    fCascadesLoaded = kFALSE;
    fGuidesLoaded = kFALSE;
    fGeometrySet = kTRUE;


    fVSD = new TEveVSD;
    fTimer = new TTimer();
    fTimer->Connect("Timeout()", "TVSDReader", this, "AnimateEsdTracks()");

    StudentSet();

    //      GotoEvent(0);

    gEve->FullRedraw3D();
      
  }

  void Exit(){

    gEve->GetBrowser()->UnmapWindow();
    gSystem->CleanCompiledMacros();

  }

  void DetectorInfo(){

    detector = 0;

    gAliceDetectorInfo = new AliceDetectorInfo(gClient->GetRoot(), 100, 100);

  }

  void PatternInfo(){

    detector = 0;

    gAlicePatternInfo = new AlicePatternInfo(gClient->GetRoot(),100,100);

  }

  void Instructions(){

    if(globalMode == 3)
      {

	TRootHelpDialog* instructions = new TRootHelpDialog(gClient->GetRoot(), "TEACHER MODE INSTRUCTIONS", 700, 600);

	instructions->SetText("\
Welcome in the <Teacher> mode, here you can see the tools to merge and analyse\n\
your students' results\n\n\
\
On the left hand side panel you can see four panels, called <Teacher Instructions>,\n\
<Teacher Controls>, <Results> and <Encyclopaedia>:\n\n\
\
   Instructions - desribes how to operate the application in the <Teacher> mode\n\
   Teacher controls - allows you to merge and analayze students' results.\n\
      Get Files - this allows to get your students' results\n\
      Save Histograms - saves histograms showing your students' results\n\
   Results\n\
      Level 1 - shows and interprets the analysis results in Level 1\n\
      Level 2 - shows and interprets the analysis results in Level 2\n\n\
Encyclopedia:\n\
   ALICE detector - description of ALICE and its main components;\n\
   V0 Decay Patterns - patterns of the particles you will be looking for;\n\
   (NOTE: click on the pictures of the detectors/decays to get further\n\
   information)\n\n\
\
In the bottom, there are main application control buttons:\n\
   Student Mode - starts the application in the Student mode,\n\
   Exit\n\n\
\
How to merge and analyze the students' results\n\n\
\
   1. Click the button <Get Files> and a window <Open> will appear.\n\
   2. Find the result (filetype *.masterclass) and click <Open>. The result\n\
      will be loaded. Repeat it for all the students' files\n\
   3. Click on the tab <Merged Invariant Mass> (right-hand side) to see\n\
      the invariant mass of the strange particles found by your students.\n\
      Update the histograms by clicking on each of them.\n\
   4. Click on the tab <Merged Rapidity> (right-hand side) to see see the\n\
      rapidity distibutions\n\
   5. Click <Save Histograms>, give the title of the pictures and <Save>\n\
   6. Click <Level 1>. A table called <Strange Particle Statistics> appears\n\
   7. Compare the pre-calculated results from Monte Carlo simulations with the\n\
      results of your students. Do the results agree? Yes? No? What Does it mean?\n\
   8. Close <Strange Particle Statistics> by clicking <Close>\n\
   9. Click <Level 2>. A table called <Particle Ratios> appears. Compare the ratios\n\
      of strange particles to pions in pre-calculated Monte Carlo data\n\
      and your analysis.Do the ratios agree? Is there a strangeness enhancement?\n\
   10. Click <Close>. The analysis is done!\n\n\
\
");
        instructions->DontCallClose();
	instructions->Popup();

      }


  }


  void SetForAnalysis11() { fAnalysis1 = 1; fAnalysis1TE->SetText("charged"); }
  void SetForAnalysis12() { fAnalysis1 = 2; fAnalysis1TE->SetText("positive"); }
  void SetForAnalysis13() { fAnalysis1 = 3; fAnalysis1TE->SetText("negative"); }
  void SetForAnalysis14() { fAnalysis1 = 4; fAnalysis1TE->SetText("pi(+)"); }
  void SetForAnalysis15() { fAnalysis1 = 5; fAnalysis1TE->SetText("pi(-)"); }
    //	KS: added K+/K- to the particle table	25.January.2011
  void SetForAnalysis16() { fAnalysis1 = 6; fAnalysis1TE->SetText("K(+)"); }
  void SetForAnalysis17() { fAnalysis1 = 7; fAnalysis1TE->SetText("K(-)"); }
  void SetForAnalysis18() { fAnalysis1 = 8; fAnalysis1TE->SetText("p(+)"); }
  void SetForAnalysis19() { fAnalysis1 = 9; fAnalysis1TE->SetText("p(-)"); }

  void SetForAnalysis21() { fAnalysis2 = 1; fAnalysis2TE->SetText("charged"); }
  void SetForAnalysis22() { fAnalysis2 = 2; fAnalysis2TE->SetText("positive"); }
  void SetForAnalysis23() { fAnalysis2 = 3; fAnalysis2TE->SetText("negative"); }
  void SetForAnalysis24() { fAnalysis2 = 4; fAnalysis2TE->SetText("pi(+)"); }
  void SetForAnalysis25() { fAnalysis2 = 5; fAnalysis2TE->SetText("pi(-)"); }
    // KS: added K+/K- to the particle table	25.January.2011
  void SetForAnalysis26() { fAnalysis2 = 6; fAnalysis2TE->SetText("K(+)"); }
  void SetForAnalysis27() { fAnalysis2 = 7; fAnalysis2TE->SetText("K(-)"); }	
  void SetForAnalysis28() { fAnalysis2 = 8; fAnalysis2TE->SetText("p(+)"); }	
  void SetForAnalysis29() { fAnalysis2 = 9; fAnalysis2TE->SetText("p(-)"); }	


  void CombineV0Candidates()
  {

    if(AC<4) {
    	AC=AC+1;
	cout << AC << endl; }
    else  {
    	AC=1;
	cout << AC <<endl; }	
	
    fPad->cd(AC);

    fFitPolynomial = NULL;
    fFitGaus = NULL;

    fMinvHisto = new TH1D("Invariant Mass","Invariant Mass",400,0.0,2.0);
    fMinvHisto->SetLineColor(2);
    fMinvHisto->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
    fMinvHisto->GetYaxis()->SetTitle("Counts");
    fMinvHisto->SetFillColor(0);

//    fMinvHisto->Reset();


    Int_t maxEvent = fMaxEv;

    for(Int_t nEvents = 0; nEvents < maxEvent; nEvents++)
    {

    if(nEvents%100 == 0) cout << "LOADED EVENT " << nEvents << endl;

    LoadEvent(nEvents);

    if(fVSD->fTreeV0)
    {

///      Int_t pdg;
      TEveVector pPos;
      TEveVector pNeg;
      Double_t massN, massP;

      Int_t nV0s = fVSD->fTreeV0->GetEntries();

      for(Int_t i=0; i<nV0s; ++i)
      {

        fVSD->fTreeV0->GetEntry(i);

        pPos = fVSD->fV0.fPPos;
        pNeg = fVSD->fV0.fPNeg;

       if((fAnalysis1 == fAnalysis2) && (fAnalysis2 > 1)) continue;

       if(fAnalysis1 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis1 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis1 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis1 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis1 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis1 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

       if(fAnalysis2 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis2 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis2 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis2 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis2 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis2 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[0])
         {
           case 0: massP = gMassElecton; break;
           case 1: massP = gMassMuon; break;
           case 2: massP = gMassPion; break;
           case 3: massP = gMassKaon; break;
           case 4: massP = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massP = gMassKaon; break;
           default: massP = gMassPion;
         }

         Double_t energyP = TMath::Sqrt(pPos.fX*pPos.fX+pPos.fY*pPos.fY+pPos.fZ*pPos.fZ+massP*massP);

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[1])
         {
           case 0: massN = gMassElecton; break;
           case 1: massN = gMassMuon; break;
           case 2: massN = gMassPion; break;
           case 3: massN = gMassKaon; break;
           case 4: massN = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massN = gMassKaon; break;
           default: massN = gMassPion;
         }

         Double_t energyN = TMath::Sqrt(pNeg.fX*pNeg.fX+pNeg.fY*pNeg.fY+pNeg.fZ*pNeg.fZ+massN*massN);

         Double_t minv = TMath::Sqrt((energyP+energyN)*(energyP+energyN)-(pPos.fX+pNeg.fX)*(pPos.fX+pNeg.fX)-(pPos.fY+pNeg.fY)*(pPos.fY+pNeg.fY)-(pPos.fZ+pNeg.fZ)*(pPos.fZ+pNeg.fZ));

         fMinvHisto->Fill(minv);

      }
    }
    }

    fMinvHisto->Draw();
    fPad->Update();

    GotoEvent(0);

  }
//---------------
void CombineV0Kaon()
  {

    if(AC<4) {
    	AC=AC+1;
	cout << AC << endl; }
    else  {
    	AC=1;
	cout << AC <<endl; }	
	
    fPad->cd(AC);

    fFitPolynomial = NULL;
    fFitGaus = NULL;

    fMinvHisto = new TH1D("Invariant Mass","Invariant Mass",200,0.2,0.7);
    fMinvHisto->SetLineColor(2);
    fMinvHisto->GetXaxis()->SetTitle("Invariant Mass Kaon(GeV/c^{2})");
    fMinvHisto->GetYaxis()->SetTitle("Counts");
    fMinvHisto->SetFillColor(0);


//    fMinvHisto->Reset();


    Int_t maxEvent = fMaxEv;

    for(Int_t nEvents = 0; nEvents < maxEvent; nEvents++)
    {

    if(nEvents%100 == 0) cout << "LOADED EVENT " << nEvents << endl;

    LoadEvent(nEvents);

    if(fVSD->fTreeV0)
    {

///      Int_t pdg;
      TEveVector pPos;
      TEveVector pNeg;
      Double_t massN, massP;

      Int_t nV0s = fVSD->fTreeV0->GetEntries();

      for(Int_t i=0; i<nV0s; ++i)
      {

        fVSD->fTreeV0->GetEntry(i);

        pPos = fVSD->fV0.fPPos;
        pNeg = fVSD->fV0.fPNeg;

       if((fAnalysis1 == fAnalysis2) && (fAnalysis2 > 1)) continue;

       if(fAnalysis1 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis1 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis1 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis1 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis1 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis1 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

       if(fAnalysis2 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis2 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis2 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis2 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis2 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis2 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[0])
         {
           case 0: massP = gMassElecton; break;
           case 1: massP = gMassMuon; break;
           case 2: massP = gMassPion; break;
           case 3: massP = gMassKaon; break;
           case 4: massP = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massP = gMassKaon; break;
           default: massP = gMassPion;
         }

         Double_t energyP = TMath::Sqrt(pPos.fX*pPos.fX+pPos.fY*pPos.fY+pPos.fZ*pPos.fZ+massP*massP);

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[1])
         {
           case 0: massN = gMassElecton; break;
           case 1: massN = gMassMuon; break;
           case 2: massN = gMassPion; break;
           case 3: massN = gMassKaon; break;
           case 4: massN = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massN = gMassKaon; break;
           default: massN = gMassPion;
         }

         Double_t energyN = TMath::Sqrt(pNeg.fX*pNeg.fX+pNeg.fY*pNeg.fY+pNeg.fZ*pNeg.fZ+massN*massN);

         Double_t minv = TMath::Sqrt((energyP+energyN)*(energyP+energyN)-(pPos.fX+pNeg.fX)*(pPos.fX+pNeg.fX)-(pPos.fY+pNeg.fY)*(pPos.fY+pNeg.fY)-(pPos.fZ+pNeg.fZ)*(pPos.fZ+pNeg.fZ));

 if (massP==gMassPion && massN==gMassPion) 
        { fMinvHisto->Fill(minv);}


      }
    }
    }

    fMinvHisto->Draw();
    fPad->Update();

    GotoEvent(0);

  }


  void CombineV0Lambda()
  {

    if(AC<4) {
    	AC=AC+1;
	cout << AC << endl; }
    else  {
    	AC=1;
	cout << AC <<endl; }	
	
    fPad->cd(AC);

    fFitPolynomial = NULL;
    fFitGaus = NULL;

    fMinvHisto = new TH1D("Invariant Mass","Invariant Mass",400,0.9,1.9);
    fMinvHisto->SetLineColor(2);
    fMinvHisto->GetXaxis()->SetTitle("Invariant Mass Lambda(GeV/c^{2})");
    fMinvHisto->GetYaxis()->SetTitle("Counts");
    fMinvHisto->SetFillColor(0);

//    fMinvHisto->Reset();


    Int_t maxEvent = fMaxEv;

    for(Int_t nEvents = 0; nEvents < maxEvent; nEvents++)
    {

    if(nEvents%100 == 0) cout << "LOADED EVENT " << nEvents << endl;

    LoadEvent(nEvents);

    if(fVSD->fTreeV0)
    {

///      Int_t pdg;
      TEveVector pPos;
      TEveVector pNeg;
      Double_t massN, massP;

      Int_t nV0s = fVSD->fTreeV0->GetEntries();

      for(Int_t i=0; i<nV0s; ++i)
      {

        fVSD->fTreeV0->GetEntry(i);

        pPos = fVSD->fV0.fPPos;
        pNeg = fVSD->fV0.fPNeg;

       if((fAnalysis1 == fAnalysis2) && (fAnalysis2 > 1)) continue;

       if(fAnalysis1 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis1 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis1 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis1 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis1 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis1 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

       if(fAnalysis2 == 4 && fVSD->fV0.fDLabel[0] != 2) continue;
       if(fAnalysis2 == 5 && fVSD->fV0.fDLabel[1] != 2) continue;

       if(fAnalysis2 == 6 && fVSD->fV0.fDLabel[0] != 3) continue;
       if(fAnalysis2 == 7 && fVSD->fV0.fDLabel[1] != 3) continue;

       if(fAnalysis2 == 8 && fVSD->fV0.fDLabel[0] != 4) continue;
       if(fAnalysis2 == 9 && fVSD->fV0.fDLabel[1] != 4) continue;

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[0])
         {
           case 0: massP = gMassElecton; break;
           case 1: massP = gMassMuon; break;
           case 2: massP = gMassPion; break;
           case 3: massP = gMassKaon; break;
           case 4: massP = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massP = gMassKaon; break;
           default: massP = gMassPion;
         }

         Double_t energyP = TMath::Sqrt(pPos.fX*pPos.fX+pPos.fY*pPos.fY+pPos.fZ*pPos.fZ+massP*massP);

//              KS: added break statements
         switch(fVSD->fV0.fDLabel[1])
         {
           case 0: massN = gMassElecton; break;
           case 1: massN = gMassMuon; break;
           case 2: massN = gMassPion; break;
           case 3: massN = gMassKaon; break;
           case 4: massN = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
           case 5: massN = gMassKaon; break;
           default: massN = gMassPion;
         }

         Double_t energyN = TMath::Sqrt(pNeg.fX*pNeg.fX+pNeg.fY*pNeg.fY+pNeg.fZ*pNeg.fZ+massN*massN);

         Double_t minv = TMath::Sqrt((energyP+energyN)*(energyP+energyN)-(pPos.fX+pNeg.fX)*(pPos.fX+pNeg.fX)-(pPos.fY+pNeg.fY)*(pPos.fY+pNeg.fY)-(pPos.fZ+pNeg.fZ)*(pPos.fZ+pNeg.fZ));

if ((massP==gMassProton && massN==gMassPion) || (massP==gMassPion && massN==gMassProton))
{
         fMinvHisto->Fill(minv);
}
      }
    }
    }

    fMinvHisto->Draw();
    fPad->Update();

    GotoEvent(0);

  }
//-----------------

  void CombineAll() { Combine(kTRUE); }
  void Combine100() { Combine(kFALSE); }

  void Combine(Bool_t allEvents)
  {

    if(!fAnalysis1 || !fAnalysis2) return;

    TString pair1 = "";
    TString pair2 = "";

    Int_t maxEvent;

    if(allEvents) { maxEvent = fMaxEv; }
    else { maxEvent = 100; }
    
//	KS: added an overview of four different histograms		24th.January.2011
    
    if(AC<4) {
    	AC=AC+1;
	cout << AC << endl; }
    else  {
    	AC=1;
	cout << AC <<endl; }	
	
    fPad->cd(AC);

    fFitPolynomial = NULL;
    fFitGaus = NULL;

    switch(fAnalysis1)
    {
       case 1: pair1 = "Charged"; break;
       case 2: pair1 = "Positive"; break;
       case 3: pair1 = "Negative"; break;
       case 4: pair1 = "Pion+"; break;
       case 5: pair1 = "Pion-"; break;
       case 6: pair1 = "Kaon+"; break;
       case 7: pair1 = "Kaon-"; break;
       case 8: pair1 = "Proton"; break;
       case 9: pair1 = "antiProton"; break;
       default: pair1 = ""; break;
    }

    switch(fAnalysis2)
    {
       case 1: pair2 = "Charged"; break;
       case 2: pair2 = "Positive"; break;
       case 3: pair2 = "Negative"; break;
       case 4: pair2 = "Pion+"; break;
       case 5: pair2 = "Pion-"; break;
       case 6: pair2 = "Kaon+"; break;
       case 7: pair2 = "Kaon-"; break;
       case 8: pair2 = "Proton"; break;
       case 9: pair2 = "antiProton"; break;
       default: pair2 = ""; break;
    }

    fMinvHisto = new TH1D("Invariant Mass",Form("%s %s",pair1.Data(),pair2.Data()),400,0.0,2.0);
    fMinvHisto->SetLineColor(2);
    fMinvHisto->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
    fMinvHisto->GetYaxis()->SetTitle("Counts");
    fMinvHisto->SetFillColor(0);

//	KS: fixed the problem that new histograms were just added to the old ones	24th.January.2011
    
    for(Int_t nEvents = 0; nEvents < maxEvent; nEvents++)
    {

    if(nEvents%100 == 0) cout << "LOADED EVENT " << nEvents << endl;

    LoadEvent(nEvents);

    Int_t nTracks = fVSD->fTreeR->GetEntries();

    TEveTrackPropagator* trkProp = fTrackList->GetPropagator();

    for(Int_t i = 0; i < nTracks; i++)
    {

       fVSD->fTreeR->GetEntry(i);
       TEveTrack* track1 = new TEveTrack(&fVSD->fR, trkProp);

       if(fAnalysis1 == 2 && track1->GetCharge() < 0) continue;
       if(fAnalysis1 == 3 && track1->GetCharge() > 0) continue;

       if(fAnalysis1 == 4 && (track1->GetCharge() < 0 || track1->GetStatus() != 2)) continue;
       if(fAnalysis1 == 5 && (track1->GetCharge() > 0 || track1->GetStatus() != 2)) continue;
//	KS: defining the K+/K-	25th.January.2011

       if(fAnalysis1 == 6 && (track1->GetCharge() < 0 || track1->GetStatus() != 3)) continue;
       if(fAnalysis1 == 7 && (track1->GetCharge() > 0 || track1->GetStatus() != 3)) continue;

       if(fAnalysis1 == 8 && (track1->GetCharge() > 0 || track1->GetStatus() != 4)) continue;
       if(fAnalysis1 == 9 && (track1->GetCharge() > 0 || track1->GetStatus() != 4)) continue;

       Double_t px1 = track1->GetMomentum().fX;
       Double_t py1 = track1->GetMomentum().fY;
       Double_t pz1 = track1->GetMomentum().fZ;

       if(px1*px1+py1*py1 < 0.04) continue;

       Double_t mass1;

       switch(track1->GetStatus())
       {
         case 0: mass1 = gMassElecton; break;
         case 1: mass1 = gMassMuon; break;
         case 2: mass1 = gMassPion; break;
         case 3: mass1 = gMassKaon; break;
         case 4: mass1 = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
//         case 5: mass1 = gMassKaon; break;
         default: mass1 = gMassPion;
       }

       Double_t E1 = TMath::Sqrt(px1*px1+py1*py1+pz1*pz1+mass1*mass1);

       for(Int_t j = i; j < nTracks; j++)
       {

         fVSD->fTreeR->GetEntry(j);
         TEveTrack* track2 = new TEveTrack(&fVSD->fR, trkProp);

         if(fAnalysis2 == 2 && track2->GetCharge() < 0) continue;
         if(fAnalysis2 == 3 && track2->GetCharge() > 0) continue;
         if(fAnalysis2 == 4 && (track2->GetCharge() < 0 || track2->GetStatus() != 2)) continue;
         if(fAnalysis2 == 5 && (track2->GetCharge() > 0 || track2->GetStatus() != 2)) continue;
//	KS: defining the K+/K-	25th.January.2011
         if(fAnalysis2 == 6 && (track2->GetCharge() < 0 || track2->GetStatus() != 3)) continue;
         if(fAnalysis2 == 7 && (track2->GetCharge() > 0 || track2->GetStatus() != 3)) continue;
         if(fAnalysis2 == 8 && (track2->GetCharge() > 0 || track2->GetStatus() != 4)) continue;
         if(fAnalysis2 == 9 && (track2->GetCharge() > 0 || track2->GetStatus() != 4)) continue;

         Double_t px2 = track2->GetMomentum().fX;
         Double_t py2 = track2->GetMomentum().fY;
         Double_t pz2 = track2->GetMomentum().fZ;

         if(px2*px2+py2*py2 < 0.04) continue;

         Double_t mass2;

         switch(track2->GetStatus())
         {
           case 0: mass2 = gMassElecton; break;
           case 1: mass2 = gMassMuon; break;
           case 2: mass2 = gMassPion; break;
           case 3: mass2 = gMassKaon; break;
           case 4: mass2 = gMassProton; break;
//		KS: edited case 5(mass of a K+/K-)		25th.January.2011
	       case 5: mass2 = gMassKaon; break;
           default: mass2 = gMassPion;
         }

         Double_t E2 = TMath::Sqrt(px2*px2+py2*py2+pz2*pz2+mass2*mass2);

         Double_t minv = TMath::Sqrt((E1+E2)*(E1+E2)-(px1+px2)*(px1+px2)-(py1+py2)*(py1+py2)-(pz1+pz2)*(pz1+pz2));


         fMinvHisto->Fill(minv);

       }
       

    }
    }

    fMinvHisto->Draw();
    fPad->Update();

    GotoEvent(0);

  }


  void FitInvariantMass()
  {
    
    Double_t MinRange = TMath::Min(fFitRangePoly->GetMin(),fFitRangeGaus->GetMin());
    Double_t MaxRange = TMath::Max(fFitRangePoly->GetMax(),fFitRangeGaus->GetMax());

    if (!fFitGaus) fFitGaus = new TF1("fitGaus","[0]*TMath::Gaus(x,[1],[2])+[3]*x*x+[4]*x+[5]",MinRange,MaxRange);
    else fFitGaus->SetRange(MinRange,MaxRange);

    fFitGaus->SetParameter(0,80.);
    fFitGaus->SetParameter(1,0.5*(fFitRangeGaus->GetMin()+fFitRangeGaus->GetMax()));
    fFitGaus->SetParameter(2,1.);
    fFitGaus->SetParLimits(0,0.,TMath::Power(10.,9));    
    fFitGaus->SetParLimits(1,fFitRangeGaus->GetMin(),fFitRangeGaus->GetMax());    
    fFitGaus->SetParLimits(2,0.,(fFitRangeGaus->GetMax()-fFitRangeGaus->GetMin())/2.);

    fFitGaus->SetLineColor(kGreen+1);
    fMinvHisto->Fit(fFitGaus,"rme");

    TLatex *labels2 = new TLatex();
    labels2->SetTextSize(0.045);
    labels2->SetTextColor(kBlack);
    labels2->SetNDC(kTRUE);
    Double_t LabelX = 0.5;
    Double_t LabelY = 0.8;
    Double_t LabelYstep = 0.05;
      
    Int_t Total_Fit = (Int_t)(fFitGaus->Integral(fFitRangeGaus->GetMin(),fFitRangeGaus->GetMax())/fMinvHisto->GetBinWidth(1));
    Int_t Bck_Fit = (Int_t)(Background_Integral(fFitRangeGaus->GetMin(),fFitRangeGaus->GetMax())/fMinvHisto->GetBinWidth(1));

    labels2->DrawLatex(LabelX, LabelY,Form("Total: %d",Total_Fit));
    labels2->DrawLatex(LabelX, LabelY-LabelYstep,Form("Background: %d",Bck_Fit));
    labels2->DrawLatex(LabelX, LabelY-2.*LabelYstep,Form("Signal: %d",Total_Fit-Bck_Fit));
    labels2->DrawLatex(LabelX, LabelY-3.*LabelYstep,Form("Mean: %f#pm%f",fFitGaus->GetParameter(1)*1000., fFitGaus->GetParError(1)*1000.));
    labels2->DrawLatex(LabelX, LabelY-4.*LabelYstep,Form("#sigma: %f#pm%f",fFitGaus->GetParameter(2)*1000., fFitGaus->GetParError(2)*1000.));
    
    if(!fFitPolynomial) fFitPolynomial = new TF1("fitPoly","[0]*x*x+[1]*x+[2]",MinRange,MaxRange);
    else fFitPolynomial->SetRange(MinRange,MaxRange);
    fFitPolynomial->SetParameter(0,fFitGaus->GetParameter(3));
    fFitPolynomial->SetParameter(1,fFitGaus->GetParameter(4));
    fFitPolynomial->SetParameter(2,fFitGaus->GetParameter(5));
    fFitPolynomial->SetLineColor(kBlue+1);
    fFitPolynomial->Draw("SAME");
      
    fPad->Update();
  }
    
    Double_t Background_Integral(Double_t xmin, Double_t xmax) {
    
        return (xmax-xmin)*(fFitGaus->GetParameter(5)+fFitGaus->GetParameter(4)*(xmax+xmin)/2.)+(fFitGaus->GetParameter(3)*(TMath::Power(xmax,3) - TMath::Power(xmin,3))/3.);
        
    }

  void LoadHist1() { LoadHist(1); };
  void LoadHist2() { LoadHist(2); };
  void LoadHist3() { LoadHist(3); };
  void LoadHist4() { LoadHist(4); };

  void LoadHist(Int_t pad)
  {

    TString species;

    switch(fLoadDir->GetSelected())
    {
      case 1:
        species = "K0s";
        break;
      case 2:
        species = "Lambda";
        break;
      case 3:
        species = "antiLambda";
        break;
      case 4:
        species = "Phi";
        break;
      case 5:
        species = "Xi";
        break;
      default:
        species = "";
        break;
    }

    TString path = gSystem->Getenv("ALICE_MASTERCLASS_DIR");
    if (path.IsNull()) path = ".";
	  
    TString *baseDirPath = new TString(Form("%s/%s/lg_analysis/%s", path.Data(), fTeacherName->GetDisplayText().Data(), species.Data()));
    TSystemDirectory *baseDir = new TSystemDirectory(".",baseDirPath->Data());      
    gSystem->Exec("rm result.root");
    TList *listOfFilesInBaseDir = baseDir->GetListOfFiles();
    Int_t nFiles = listOfFilesInBaseDir->GetEntries();
    TFileMerger *mer = new TFileMerger();
    for(Int_t i = 0; i < nFiles; i++)
    {
      TSystemFile* currentFile = (TSystemFile*)listOfFilesInBaseDir->At(i);
        cout << "list: " << currentFile->GetName() << endl;
        if( strcmp(currentFile->GetName(), ".") == 0 ) continue;
        if( strstr(currentFile->GetName(), ".root") == 0 ) continue;
      if( strcmp(currentFile->GetName(), "..") == 0 ) continue;
        if( strcmp(currentFile->GetName(), "result.root") == 0 ) continue;
      mer->AddFile(currentFile->GetName());
    }
    mer->OutputFile("result.root");
    mer->Merge();
    delete mer;

    TFile *f = new TFile(Form("%s/%s/lg_analysis/%s/result.root", path.Data(), fTeacherName->GetDisplayText().Data(), species.Data()));
    
    fMinvHisto = (TH1D*)f->Get("Invariant Mass");

    switch(fLoadDir->GetSelected())
    {
      case 1:
        fMinvHisto->SetTitle("K0s");
        break;
      case 2:
        fMinvHisto->SetTitle("Lambda");
        break;
      case 3:
        fMinvHisto->SetTitle("antiLambda");
        break;
      case 4:
        fMinvHisto->SetTitle("Phi");
        break;
      case 5:
        fMinvHisto->SetTitle("Xi");
        break;
      default:
        fMinvHisto->SetTitle("");
        break;
    }
    
    fPad->cd(pad);
    fMinvHisto->Draw();
    fPad->Update();

  }


    void SaveHisto(Int_t pad_num)
    {
        
        TString species;
        
        switch(fSaveDir->GetSelected())
        {
            case 1:
                species = "K0s";
                break;
            case 2:
                species = "Lambda";
                break;
            case 3:
                species = "antiLambda";
                break;
            case 4:
                species = "Phi";
                break;
            case 5:
                species = "Xi";
                break;
            default:
                species = "";
                break;
        }
        
        TString path = gSystem->Getenv("ALICE_MASTERCLASS_DIR");
        if (path.IsNull()) path = ".";
        
        if(fPad->cd(1)->FindObject("Invariant Mass"))
            cout << (static_cast<TH1D*>(fPad->cd(1)->FindObject("Invariant Mass")))->GetEntries() << endl;
        (static_cast<TH1D*>(fPad->cd(pad_num)->FindObject("Invariant Mass")))->SaveAs(Form("%s/%s/lg_analysis/%s/%s%s.root",path.Data(), fTeacherName->GetDisplayText().Data(), species.Data(), globalName1.Data(), globalName2.Data()));
        
    }
    void SaveHist1() { SaveHisto(1); }
    void SaveHist2() { SaveHisto(2); }
    void SaveHist3() { SaveHisto(3); }
    void SaveHist4() { SaveHisto(4); }

  void AutomaticMenu()
  {

    TEveBrowser* browser = gEve->GetBrowser();

    browser->GetMainFrame()->SetWindowName(Form("ALICE MasterClass - STUDENT MODE - %s and %s", globalName1.Data(),globalName2.Data()));

    if(browser->GetTabRight()->GetTabTab(3))
      browser->GetTabRight()->RemoveTab(3);

    if(browser->GetTabRight()->GetTabTab(2))
      browser->GetTabRight()->RemoveTab(2);

    if(browser->GetTabLeft()->GetTabTab(1))
      browser->GetTabLeft()->RemoveTab(1);

    if(browser->GetTabLeft()->GetTabTab(0))
      browser->GetTabLeft()->RemoveTab(0);

    if(browser->GetTabBottom()->GetTabTab(0))
      browser->GetTabBottom()->RemoveTab(0);

    browser->StartEmbedding(TRootBrowser::kLeft);

    TGMainFrame* frmMain = new TGMainFrame(gClient->GetRoot(), 1000, 600);
    frmMain->SetWindowName("XX GUI");
    frmMain->SetCleanup(kDeepCleanup);

    TString icondir(TString::Format("%s/icons/", gSystem->Getenv("ROOTSYS")) );
    TGPictureButton* b1 = 0;
    TGTextButton* b = 0;
    TGGroupFrame* gf = 0;
    TGVerticalFrame* vf = 0;
    TGHorizontalFrame* hf = 0;
    ULong_t buttonRedColor;

    gf = new TGGroupFrame(frmMain, "Analysis tools");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

    hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        fAnalysis1TE = new TGTextEntry(hf, "choose");
        fAnalysis1TE->SetEnabled(kFALSE);
        fAnalysis1TE->SetAlignment(kTextCenterX);
        hf->AddFrame(fAnalysis1TE, new TGLayoutHints(kLHintsExpandX));

        fAnalysis2TE = new TGTextEntry(hf, "choose");
        fAnalysis2TE->SetEnabled(kFALSE);
        fAnalysis2TE->SetAlignment(kTextCenterX);
        hf->AddFrame(fAnalysis2TE, new TGLayoutHints(kLHintsExpandX));

      }

   vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));


      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Charged");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis11()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Charged");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis21()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Positive");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis12()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Positive");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis22()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Negative");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis13()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Negative");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis23()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Pion+");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis14()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Pion+");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis24()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }


      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Pion-");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis15()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Pion-");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis25()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {
//  KS: added K+/K- TextButtons
        b = new TGTextButton(hf, "Kaon+");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis16()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Kaon+");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis26()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Kaon-");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis17()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Kaon-");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis27()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {
//  KS: added K+/K- TextButtons
        b = new TGTextButton(hf, "Proton");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis18()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "Proton");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis28()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "antiProton");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis19()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        b = new TGTextButton(hf, "antiProton");
//        b->AllowStayDown(kTRUE);
        b->Connect("Clicked()", "TVSDReader", this, "SetForAnalysis29()");
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      TGHorizontal3DLine* separator = new TGHorizontal3DLine(vf);
      vf->AddFrame(separator, new TGLayoutHints(kLHintsExpandX, 1, 1, 5, 5));
      
//	KS: changed "combine particles" to "analyse particles"	24th.January.2011

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, "Analyse first 100 events");
        b->Connect("Clicked()", "TVSDReader", this, "Combine100()");
        if(globalDataset == 8) b->SetEnabled(kFALSE);
	
//	KS: changed "combine in 100 events" to "analyse in 100 events"	24th.January.2011
	
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, Form("Analyse %d events",fMaxEv));
        b->Connect("Clicked()", "TVSDReader", this, "CombineAll()");
        if(globalDataset == 8) b->SetEnabled(kFALSE);
	
//	KS: changed "combine in all events" to "analyse all events"		24th.January.2011
	
        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "ALICE official V0 selection");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        b = new TGTextButton(hf, Form("Analyse V0s in %d events",fMaxEv));
        b->Connect("Clicked()", "TVSDReader", this, "CombineV0Candidates()");

//	KS: changed "combine V0s in all events" to "analyse V0s in all events"		24th.January.2011

        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

	b = new TGTextButton(hf, Form("Analyse Kaons"));
        b->Connect("Clicked()", "TVSDReader", this, "CombineV0Kaon()");

        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));
       

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));


 hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {
b = new TGTextButton(hf, Form("Analyse Lambdas"));
        b->Connect("Clicked()", "TVSDReader", this, "CombineV0Lambda()");

        hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));
        
      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Fit");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        fFitRangePoly = new TEveGDoubleValuator(hf,"Bkg range:", 40, 0);
        fFitRangePoly->SetNELength(5);
        fFitRangePoly->SetLabelWidth(70);
        fFitRangePoly->Build();
        fFitRangePoly->GetSlider()->SetWidth(190);
        fFitRangePoly->SetLimits(0.0, 2.0, TGNumberFormat::kNESRealThree);
        fFitRangePoly->SetValues(0.0, 2.0, TGNumberFormat::kNESRealThree);

        hf->AddFrame(fFitRangePoly, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        fFitRangeGaus = new TEveGDoubleValuator(hf,"Sig range:", 40, 0);
        fFitRangeGaus->SetNELength(5);
        fFitRangeGaus->SetLabelWidth(70);
        fFitRangeGaus->Build();
        fFitRangeGaus->GetSlider()->SetWidth(190);
        fFitRangeGaus->SetLimits(0.0, 2.0, TGNumberFormat::kNESRealThree);
        fFitRangeGaus->SetValues(0.0, 2.0, TGNumberFormat::kNESRealThree);

        hf->AddFrame(fFitRangeGaus, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));

        hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
        {
            b = new TGTextButton(hf, "Fit signal+background");
            b->Connect("Clicked()", "TVSDReader", this, "FitInvariantMass()");
            hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));
        }
        
        vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));
        
    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Save results");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        TGHorizontalFrame *hframe = new TGHorizontalFrame(hf, 40, 20, kFixedWidth);
        {

          b = new TGTextButton(hframe, "1");
          b->Connect("Clicked()", "TVSDReader", this, "SaveHist1()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

          b = new TGTextButton(hframe, "2");
          b->Connect("Clicked()", "TVSDReader", this, "SaveHist2()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe);//, new TGLayoutHints(kLHintsExpandX));

        hframe = new TGHorizontalFrame(hf, 160, 20, kFixedWidth);
        {

          fSaveDir = new TGComboBox(hframe);
          fSaveDir->AddEntry("K0s", 1);
          fSaveDir->AddEntry("Lambda", 2);
          fSaveDir->AddEntry("antiLambda", 3);
          fSaveDir->AddEntry("Phi", 4);
          fSaveDir->AddEntry("V0", 5);
          fSaveDir->Resize(100,20);
          hframe->AddFrame(fSaveDir, new TGLayoutHints(kLHintsExpandX));
        }

        hf->AddFrame(hframe, new TGLayoutHints(kLHintsExpandX));

      }
        
      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        TGHorizontalFrame* hframe = new TGHorizontalFrame(hf, 40, 20, kFixedWidth);
        {

          b = new TGTextButton(hframe, "3");
          b->Connect("Clicked()", "TVSDReader", this, "SaveHist3()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

          b = new TGTextButton(hframe, "4");
          b->Connect("Clicked()", "TVSDReader", this, "SaveHist4()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe);//, new TGLayoutHints(kLHintsExpandX));

        hframe = new TGHorizontalFrame(hf, 160, 20, kFixedWidth);
        {

          fTeacherName = new TGTextEntry(hframe, "Teacher");
          fTeacherName->SetEnabled(kTRUE);
          fTeacherName->SetAlignment(kTextCenterX);
          hframe->AddFrame(fTeacherName, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe, new TGLayoutHints(kLHintsExpandX));

      }
        
      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    vf = new TGVerticalFrame(frmMain, 150, 150, kFixedWidth);
    {

      b1 = new TGPictureButton(vf, gClient->GetPicture("eve_files/ALICE_logo_scaled.png"));

    }

    vf->AddFrame(b1);
    frmMain->AddFrame(vf);

    frmMain->MapSubwindows();
    frmMain->Resize();
    frmMain->MapWindow();

    browser->StopEmbedding("Student");

    browser->StartEmbedding(TRootBrowser::kBottom);

    frmMain = new TGMainFrame(gClient->GetRoot(), 1000, 600, kHorizontalFrame);
    frmMain->SetWindowName("XX GUI");
    frmMain->SetCleanup(kDeepCleanup);

    //   hf = new TGHorizontalFrame(frmMain);

    const TGFont *font = gClient->GetFont("-*-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*");
    FontStruct_t buttonFont = font->GetFontStruct();

    gClient->GetColorByName("red", buttonRedColor);
    b = new TGTextButton(frmMain,"Exit");
    b->SetTextColor(buttonRedColor);
    b->SetFont(buttonFont);
    //   hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY , 1, 1, 1, 1));
    b->Connect("Clicked()", "TApplication", gApplication, "Terminate()");

    frmMain->AddFrame(b, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY , 1, 1, 1, 1));

    frmMain->MapSubwindows();
    frmMain->Resize();
    frmMain->MapWindow();

    browser->StopEmbedding(" ");

    browser->StartEmbedding(TRootBrowser::kRight);

    fPad = new TCanvas();
    fPad->Divide(2, 2);
    fPad->cd(1);

    fMinvHisto = new TH1D("Invariant Mass","Invariant Mass",400,0.0,2.0);

    if(AC<=4) {
    	AC=AC+1; 
	cout << AC << endl;}
//	KS: added a loop-function for the histograms	24th.January.2011
	
    else {
    	AC=1; 
	cout << AC << endl;}

    fPad->cd(AC);
    fMinvHisto->SetLineColor(2);
    fMinvHisto->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
    fMinvHisto->GetYaxis()->SetTitle("Counts");
    fMinvHisto->SetFillColor(0);

    //fMinvHisto->Draw();
    //fPad->Draw();

    browser->StopEmbedding("Invariant Mass Distibution");

    browser->GetTabRight()->SetTab(2);

  }

  void StudentSet(){

    if(globalMode == 3)
      {

        globalMode = 2;
        globalChoice = 2;

      }

    AutomaticMenu();

  }

  void TeacherSet(){

    TEveBrowser* browser = gEve->GetBrowser();

    browser->GetMainFrame()->SetWindowName("ALICE MasterClass - TEACHER MODE");

    if(browser->GetTabRight()->GetTabTab(3))
      browser->GetTabRight()->RemoveTab(3);

    if(browser->GetTabRight()->GetTabTab(2))
      browser->GetTabRight()->RemoveTab(2);

    if(browser->GetTabLeft()->GetTabTab(0))
      browser->GetTabLeft()->RemoveTab(0);

    if(browser->GetTabLeft()->GetTabTab(1))
      browser->GetTabLeft()->RemoveTab(1);

    if(browser->GetTabBottom()->GetTabTab(0))
      browser->GetTabBottom()->RemoveTab(0);

    browser->StartEmbedding(TRootBrowser::kRight);

    fPad = new TCanvas();
    fPad->Divide(2, 2);
    fPad->cd(1);

    browser->StopEmbedding("Invariant Mass Distibution");

    browser->StartEmbedding(TRootBrowser::kLeft);

    TString icondir(TString::Format("%s/icons/", gSystem->Getenv("ROOTSYS")) );
    TGPictureButton* b1 = 0;
    TGTextButton* b = 0;
    TGGroupFrame* gf = 0;
    TGVerticalFrame* vf = 0;
    TGHorizontalFrame* hf = 0;
    ULong_t buttonRedColor;

    TGMainFrame* frmMain = new TGMainFrame(gClient->GetRoot(), 1000, 600);
    frmMain->SetWindowName("XX GUI");
    frmMain->SetCleanup(kDeepCleanup);

    gf = new TGGroupFrame(frmMain, "Teacher Instructions");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);

    {

      const TGFont *font = gClient->GetFont("-*-times-bold-r-*-*-16-*-*-*-*-*-*-*");
      FontStruct_t buttonFont = font->GetFontStruct();
      gClient->GetColorByName("red", buttonRedColor);
      b = new TGTextButton(vf,"Instructions");
      b->SetTextColor(buttonRedColor);
      b->SetFont(buttonFont);
      vf->AddFrame(b, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
      b->Connect("Clicked()", "TVSDReader", this, "Instructions()");

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Navigate");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

	TGLabel* label = new TGLabel(hf, "Previous");
	hf->AddFrame(label, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

	label = new TGLabel(hf, "Current");
	hf->AddFrame(label, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

	label = new TGLabel(hf, "Next");
	hf->AddFrame(label, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

	b1 = new TGPictureButton(hf, gClient->GetPicture(icondir + "GoBack.gif"));
	hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
	b1->Connect("Clicked()", "TVSDReader", this, "PrevEvent()");

	gEventNumber = new TGLabel(hf);
	gEventNumber->SetText(1);
	hf->AddFrame(gEventNumber, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

	b1 = new TGPictureButton(hf, gClient->GetPicture(icondir + "GoForward.gif"));
	hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
	b1->Connect("Clicked()", "TVSDReader", this, "NextEvent()");
      }


      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    gf = new TGGroupFrame(frmMain, "Animate event");

    hf = new TGHorizontalFrame(gf, 200, 20, kFixedWidth);
    {

      b1 = new TGPictureButton(hf, gClient->GetPicture(icondir + "ed_execute.png"));
      hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
      b1->Connect("Clicked()", "TVSDReader", this, "StartAnimation()");

      b1 = new TGPictureButton(hf, gClient->GetPicture(icondir + "ed_interrupt.png"));
      hf->AddFrame(b1, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
      b1->Connect("Clicked()", "TVSDReader", this, "StopAnimation()");

    }

    gf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Teacher Controls");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);

    {

      b = new TGTextButton(vf,"Activate V0 finder");
      vf->AddFrame(b, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
      b->Connect("Clicked()", "TVSDReader", this, "ActivateV0Finder()");

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

//    frmMain->AddFrame(gf);


    gf = new TGGroupFrame(frmMain, "Get Files");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        TGHorizontalFrame *hframe = new TGHorizontalFrame(hf, 40, 20, kFixedWidth);
        {

          b = new TGTextButton(hframe, "1");
          b->Connect("Clicked()", "TVSDReader", this, "LoadHist1()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

          b = new TGTextButton(hframe, "2");
          b->Connect("Clicked()", "TVSDReader", this, "LoadHist2()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe);//, new TGLayoutHints(kLHintsExpandX));

        hframe = new TGHorizontalFrame(hf, 160, 20, kFixedWidth);
        {

          fLoadDir = new TGComboBox(hframe);
          fLoadDir->AddEntry("K0s", 1);
          fLoadDir->AddEntry("Lambda", 2);
          fLoadDir->AddEntry("antiLambda", 3);
          fLoadDir->AddEntry("Phi", 4);
          fLoadDir->AddEntry("V0", 5);
          fLoadDir->Resize(100,20);
          hframe->AddFrame(fLoadDir, new TGLayoutHints(kLHintsExpandX));
        }

        hf->AddFrame(hframe, new TGLayoutHints(kLHintsExpandX));

      }
        
      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        TGHorizontalFrame* hframe = new TGHorizontalFrame(hf, 40, 20, kFixedWidth);
        {

          b = new TGTextButton(hframe, "3");
          b->Connect("Clicked()", "TVSDReader", this, "LoadHist3()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

          b = new TGTextButton(hframe, "4");
          b->Connect("Clicked()", "TVSDReader", this, "LoadHist4()");
          hframe->AddFrame(b, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe);//, new TGLayoutHints(kLHintsExpandX));

        hframe = new TGHorizontalFrame(hf, 160, 20, kFixedWidth);
        {

          fTeacherName = new TGTextEntry(hframe, "Teacher");
          fTeacherName->SetEnabled(kTRUE);
          fTeacherName->SetAlignment(kTextCenterX);
          hframe->AddFrame(fTeacherName, new TGLayoutHints(kLHintsExpandX));

        }

        hf->AddFrame(hframe, new TGLayoutHints(kLHintsExpandX));

      }
        
      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Fit");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        fFitRangePoly = new TEveGDoubleValuator(hf,"Bkg range:", 40, 0);
        fFitRangePoly->SetNELength(5);
        fFitRangePoly->SetLabelWidth(70);
        fFitRangePoly->Build();
        fFitRangePoly->GetSlider()->SetWidth(190);
        fFitRangePoly->SetLimits(0.0, 2.0, TGNumberFormat::kNESRealThree);
        fFitRangePoly->SetValues(0.0, 2.0, TGNumberFormat::kNESRealThree);

        hf->AddFrame(fFitRangePoly, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));

      hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
      {

        fFitRangeGaus = new TEveGDoubleValuator(hf,"Sig range:", 40, 0);
        fFitRangeGaus->SetNELength(5);
        fFitRangeGaus->SetLabelWidth(70);
        fFitRangeGaus->Build();
        fFitRangeGaus->GetSlider()->SetWidth(190);
        fFitRangeGaus->SetLimits(0.0, 2.0, TGNumberFormat::kNESRealThree);
        fFitRangeGaus->SetValues(0.0, 2.0, TGNumberFormat::kNESRealThree);

        hf->AddFrame(fFitRangeGaus, new TGLayoutHints(kLHintsExpandX));

      }

      vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));

        hf = new TGHorizontalFrame(vf, 200, 20, kFixedWidth);
        {
            b = new TGTextButton(hf, "Fit signal+background");
            b->Connect("Clicked()", "TVSDReader", this, "FitInvariantMass()");
            hf->AddFrame(b, new TGLayoutHints(kLHintsExpandX));
        }
        
        vf->AddFrame(hf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY, 5, 5, 5, 5));
        
    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    gf = new TGGroupFrame(frmMain, "Encyclopaedia");

    vf = new TGVerticalFrame(gf, 200, 20, kFixedWidth);
    {

      b = new TGTextButton(vf, "ALICE Detector");
      b->Connect("Clicked()", "TVSDReader", this, "DetectorInfo()");
      vf->AddFrame(b, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));

      b = new TGTextButton(vf, "V0 Patterns");
      b->Connect("Clicked()", "TVSDReader", this, "PatternInfo()");
      vf->AddFrame(b, new TGLayoutHints(kLHintsExpandX, 1, 1, 1, 1));
    }

    gf->AddFrame(vf, new TGLayoutHints(kLHintsExpandX | kLHintsCenterY));

    frmMain->AddFrame(gf);

    vf = new TGVerticalFrame(frmMain, 150, 150, kFixedWidth);
    {

      b1 = new TGPictureButton(vf, gClient->GetPicture("eve_files/ALICE_logo_scaled.png"));
      vf->AddFrame(b1);

    }

    frmMain->AddFrame(vf);

    frmMain->MapSubwindows();
    frmMain->Resize();
    frmMain->MapWindow();

    browser->StopEmbedding("Teacher");

    browser->GetTabRight()->SetTab(1);


    browser->StartEmbedding(TRootBrowser::kBottom);

    frmMain = new TGMainFrame(gClient->GetRoot(), 1000, 600, kHorizontalFrame);
    frmMain->SetWindowName("XX GUI");
    frmMain->SetCleanup(kDeepCleanup);

    const TGFont *font = gClient->GetFont("-*-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*");
    FontStruct_t buttonFont = font->GetFontStruct();

    gClient->GetColorByName("navy", buttonRedColor);
    b = new TGTextButton(frmMain,"Student Mode");
    b->SetTextColor(buttonRedColor);
    b->SetFont(buttonFont);
    b->Connect("Clicked()", "TVSDReader", this, "ToStudent()");

    frmMain->AddFrame(b, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY , 1, 1, 1, 1));

    gClient->GetColorByName("red", buttonRedColor);
    b = new TGTextButton(frmMain,"Exit");
    b->SetTextColor(buttonRedColor);
    b->SetFont(buttonFont);
    b->Connect("Clicked()", "TApplication", gApplication, "Terminate()");

    frmMain->AddFrame(b, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY , 1, 1, 1, 1));
    frmMain->MapSubwindows();
    frmMain->Resize();
    frmMain->MapWindow();

    browser->StopEmbedding(" ");

  }

  void GetResult1() { GetResult(1); }
  void GetResult2() { GetResult(2); }
  void GetResult3() { GetResult(3); }
  void GetResult4() { GetResult(4); }
  void GetResult5() { GetResult(5); }
  void GetResult6() { GetResult(6); }
  void GetResult7() { GetResult(7); }
  void GetResult8() { GetResult(8); }

  void GetResult(Int_t a)
  {

    TString icondir(TString::Format("%s/icons/", gSystem->Getenv("ROOTSYS")) );

    TGFileInfo fi;
    fi.fFileTypes   = gMasterClassOutputPictue;
    fi.fIniDir      = StrDup("");
    fi.fFileTypeIdx = 0;
    fi.fOverwrite   = kTRUE;
    new TGFileDialog(gClient->GetDefaultRoot(),gEve->GetMainWindow(), kFDOpen, &fi);
    if (!fi.fFilename) return;

    TPMERegexp filere(".*/([^/]+$)");

    gSystem->ChangeDirectory(fi.fIniDir);

    switch(a)
    {
      case 1:
        fResultButton1->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton1->DoRedraw();
        fResultPicture1 = fi.fFilename;
        break;
      case 2:
        fResultButton2->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton2->DoRedraw();
        fResultPicture2 = fi.fFilename;
        break;
      case 3:
        fResultButton3->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton3->DoRedraw();
        fResultPicture3 = fi.fFilename;
        break;
      case 4:
        fResultButton4->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton4->DoRedraw();
        fResultPicture4 = fi.fFilename;
        break;
      case 5:
        fResultButton5->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton5->DoRedraw();
        fResultPicture5 = fi.fFilename;
        break;
      case 6:
        fResultButton6->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton6->DoRedraw();
        fResultPicture6 = fi.fFilename;
        break;
      case 7:
        fResultButton7->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton7->DoRedraw();
        fResultPicture7 = fi.fFilename;
        break;
      case 8:
        fResultButton8->SetPicture(gClient->GetPicture(icondir + "listview.xpm"));
        fResultButton8->DoRedraw();
        fResultPicture8 = fi.fFilename;
        break;
      default: break;
    }
  }

  void ActivateV0Finder()
  {

    gSystem->Setenv("MASTERCLASS_V0_FINDER_ON","1");

  }

  void DestroyGeometry(){

    TEveSceneList* sceneList1=gEve->GetScenes();
    TEveElement::List_i i = sceneList1->BeginChildren();
    TEveSceneList* sceneList2 = (TEveSceneList*) *i;
    sceneList2->RemoveElements();
    i++;
    i++;
    TEveSceneList* sceneList3 = (TEveSceneList*) *i;
    sceneList3->RemoveElements();
    i++;
    TEveSceneList* sceneList4 = (TEveSceneList*) *i;
    sceneList4->RemoveElements();

    gMultiView->SetDepth(-10);
    gMultiView->DestroyGeomRPhi();
    gMultiView->DestroyGeomRhoZ();
    gMultiView->SetDepth(0);

    gMultiView->SetRPhiAxes();
    gMultiView->SetRhoZAxes();


  }

  void GeometryDefault(){

    TEveSceneList* sceneList1=gEve->GetScenes();
    TEveElement::List_i i = sceneList1->BeginChildren();
    TEveSceneList* sceneList2 = (TEveSceneList*) *i;
    sceneList2->RemoveElements();
    i++;
    i++;
    TEveSceneList* sceneList3 = (TEveSceneList*) *i;
    sceneList3->RemoveElements();
    i++;
    TEveSceneList* sceneList4 = (TEveSceneList*) *i;
    sceneList4->RemoveElements();

    TEveGeoShape *gentle_geom = 0;

    TFile* geom = TFile::Open("alice_mini_geom.root");
    if (!geom)
      return;
    TEveGeoShapeExtract* gse = (TEveGeoShapeExtract*) geom->Get("Gentle");
    gentle_geom = TEveGeoShape::ImportShapeExtract(gse, 0);
    geom->Close();
    delete geom;

    gentle_geom->SetRnrSelf(kFALSE);

    //ITS

    i = gentle_geom->BeginChildren();

    TEveGeoShape* lvl1 = (TEveGeoShape*) *i;

    //TPC

    i++;

    //TRD+TOF

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    TEveElement::List_i j = lvl1->BeginChildren();

    TEveGeoShape* trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    j++;
    j++;
    j++;
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    j++;
    j++;
    j++;
    j++;
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

  gEve->AddGlobalElement(gentle_geom);

    gMultiView->SetDepth(-10);
    gMultiView->DestroyGeomRPhi();
    gMultiView->ImportGeomRPhi(gentle_geom);
    gMultiView->DestroyGeomRhoZ();
    gMultiView->ImportGeomRhoZ(gentle_geom);
    gMultiView->SetDepth(0);

    gMultiView->SetRPhiAxes();
    gMultiView->SetRhoZAxes();


  }

  void Geometry2(){

    TEveSceneList* sceneList1=gEve->GetScenes();
    TEveElement::List_i i = sceneList1->BeginChildren();
    TEveSceneList* sceneList2 = (TEveSceneList*) *i;
    sceneList2->RemoveElements();
    i++;
    i++;
    TEveSceneList* sceneList3 = (TEveSceneList*) *i;
    sceneList3->RemoveElements();
    i++;
    TEveSceneList* sceneList4 = (TEveSceneList*) *i;
    sceneList4->RemoveElements();

    TEveGeoShape *gentle_geom = 0;

    TFile* geom = TFile::Open("alice_mini_geom.root");
    if (!geom)
      return;
    TEveGeoShapeExtract* gse = (TEveGeoShapeExtract*) geom->Get("Gentle");
    gentle_geom = TEveGeoShape::ImportShapeExtract(gse, 0);
    geom->Close();
    delete geom;

    gentle_geom->SetRnrSelf(kFALSE);
    i = gentle_geom->BeginChildren();

    //ITS

    TEveGeoShape* lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    TEveElement::List_i j = lvl1->BeginChildren();

    TEveGeoShape* lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    TEveElement::List_i k = lvl2->BeginChildren();

    TEveGeoShape* its1 = (TEveGeoShape*) *k;
    its1->SetRnrSelf(kTRUE);
    its1->SetMainColor(kYellow-4);
    its1->SetMainTransparency(50);
    k++;

    TEveGeoShape* its2 = (TEveGeoShape*) *k;
    its2->SetRnrSelf(kTRUE);
    its2->SetMainColor(kYellow-7);
    its2->SetMainTransparency(50);
    k++;

    TEveGeoShape* its3 = (TEveGeoShape*) *k;
    its3->SetRnrSelf(kTRUE);
    its3->SetMainColor(kYellow-9);
    its3->SetMainTransparency(50);

    //TPC

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    j = lvl1->BeginChildren();

    lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    k = lvl2->BeginChildren();

    TEveGeoShape* lvl3 = (TEveGeoShape*) *k;
    lvl3->SetRnrSelf(kTRUE);
    lvl3->SetMainColor(kGray);
    lvl3->SetMainTransparency(80);
    TEveElement::List_i l = lvl3->BeginChildren();

    TEveGeoShape* lvl4 = (TEveGeoShape*) *l;
    lvl4->SetRnrSelf(kFALSE);
    TEveElement::List_i m = lvl4->BeginChildren();

    TEveGeoShape* tpc1 = (TEveGeoShape*) *m;
    tpc1->SetRnrSelf(kTRUE);
    tpc1->SetMainColor(kGray+2);
    tpc1->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc2 = (TEveGeoShape*) *m;
    tpc2->SetMainColor(kGray);
    tpc2->SetMainColor(kGray+2);
    tpc2->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc3 = (TEveGeoShape*) *m;
    tpc3->SetRnrSelf(kTRUE);
    tpc3->SetMainColor(kGray+2);
    tpc3->SetMainTransparency(80);
    m++;

    //TRD+TOF

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)
      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kFALSE);
	lvl2->SetMainColor(0);
	lvl2->SetMainTransparency(80);
      }

    //PHOS

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)
      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kTRUE);
	lvl2->SetMainTransparency(30);
      }


    gEve->AddGlobalElement(gentle_geom);

    gMultiView->SetDepth(-10);
    gMultiView->DestroyGeomRPhi();
    gMultiView->ImportGeomRPhi(gentle_geom);
    gMultiView->DestroyGeomRhoZ();
    gMultiView->ImportGeomRhoZ(gentle_geom);
    gMultiView->SetDepth(0);

    gMultiView->SetRPhiAxes();
    gMultiView->SetRhoZAxes();

  }


  void Geometry3(){

    TEveSceneList* sceneList1=gEve->GetScenes();
    TEveElement::List_i i = sceneList1->BeginChildren();
    TEveSceneList* sceneList2 = (TEveSceneList*) *i;
    sceneList2->RemoveElements();
    i++;
    i++;
    TEveSceneList* sceneList3 = (TEveSceneList*) *i;
    sceneList3->RemoveElements();
    i++;
    TEveSceneList* sceneList4 = (TEveSceneList*) *i;
    sceneList4->RemoveElements();

    TEveGeoShape *gentle_geom = 0;

    TFile* geom = TFile::Open("alice_mini_geom.root");
    if (!geom)
      return;
    TEveGeoShapeExtract* gse = (TEveGeoShapeExtract*) geom->Get("Gentle");
    gentle_geom = TEveGeoShape::ImportShapeExtract(gse, 0);
    geom->Close();
    delete geom;

    gentle_geom->SetRnrSelf(kFALSE);

    i = gentle_geom->BeginChildren();
    //ITS

    TEveGeoShape* lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    TEveElement::List_i j = lvl1->BeginChildren();

    TEveGeoShape* lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    TEveElement::List_i k = lvl2->BeginChildren();

    TEveGeoShape* its1 = (TEveGeoShape*) *k;
    its1->SetRnrSelf(kTRUE);
    its1->SetMainColor(0);
    its1->SetMainTransparency(80);
    k++;

    TEveGeoShape* its2 = (TEveGeoShape*) *k;
    its2->SetRnrSelf(kTRUE);
    its2->SetMainColor(0);
    its2->SetMainTransparency(80);
    k++;

    TEveGeoShape* its3 = (TEveGeoShape*) *k;
    its3->SetRnrSelf(kTRUE);
    its3->SetMainColor(0);
    its3->SetMainTransparency(80);

    //TPC

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    j = lvl1->BeginChildren();

    lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    k = lvl2->BeginChildren();

    TEveGeoShape* lvl3 = (TEveGeoShape*) *k;
    lvl3->SetRnrSelf(kTRUE);
    lvl3->SetMainColor(0);
    lvl3->SetMainTransparency(80);
    TEveElement::List_i l = lvl3->BeginChildren();

    TEveGeoShape* lvl4 = (TEveGeoShape*) *l;
    lvl4->SetRnrSelf(kFALSE);
    TEveElement::List_i m = lvl4->BeginChildren();

    TEveGeoShape* tpc1 = (TEveGeoShape*) *m;
    tpc1->SetRnrSelf(kTRUE);
    tpc1->SetMainColor(0);
    tpc1->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc2 = (TEveGeoShape*) *m;
    tpc2->SetMainColor(kGray);
    tpc2->SetMainColor(0);
    tpc2->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc3 = (TEveGeoShape*) *m;
    tpc3->SetRnrSelf(kTRUE);
    tpc3->SetMainColor(0);
    tpc3->SetMainTransparency(80);
    m++;

    //TRD+TOF

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    j = lvl1->BeginChildren();

    lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kTRUE);
    lvl2->SetMainColor(0);
    lvl2->SetMainTransparency(80);
    j++;

    lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kTRUE);
    lvl2->SetMainColor(0);
    lvl2->SetMainTransparency(80);

    //PHOS

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)

      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kTRUE);
	lvl2->SetMainColor(0);
	lvl2->SetMainTransparency(80);
      }

    //HMPID

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)
      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kTRUE);
	lvl2->SetMainColor(0);
	lvl2->SetMainTransparency(80);
      }

    gEve->AddGlobalElement(gentle_geom);

    gMultiView->SetDepth(-10);
    gMultiView->DestroyGeomRPhi();
    gMultiView->ImportGeomRPhi(gentle_geom);
    gMultiView->DestroyGeomRhoZ();
    gMultiView->ImportGeomRhoZ(gentle_geom);
    gMultiView->SetDepth(0);

    gMultiView->SetRPhiAxes();
    gMultiView->SetRhoZAxes();

  }

  void Geometry4(){

    TEveSceneList* sceneList1=gEve->GetScenes();
    TEveElement::List_i i = sceneList1->BeginChildren();
    TEveSceneList* sceneList2 = (TEveSceneList*) *i;
    sceneList2->RemoveElements();
    i++;
    i++;
    TEveSceneList* sceneList3 = (TEveSceneList*) *i;
    sceneList3->RemoveElements();
    i++;
    TEveSceneList* sceneList4 = (TEveSceneList*) *i;
    sceneList4->RemoveElements();

    TEveGeoShape *gentle_geom = 0;

    TFile* geom = TFile::Open("alice_mini_geom.root");
    if (!geom)
      return;
    TEveGeoShapeExtract* gse = (TEveGeoShapeExtract*) geom->Get("Gentle");
    gentle_geom = TEveGeoShape::ImportShapeExtract(gse, 0);
    geom->Close();
    delete geom;

    gentle_geom->SetRnrSelf(kFALSE);

    i = gentle_geom->BeginChildren();

    //ITS

    TEveGeoShape* lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    TEveElement::List_i j = lvl1->BeginChildren();

    TEveGeoShape* lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    TEveElement::List_i k = lvl2->BeginChildren();

    TEveGeoShape* its1 = (TEveGeoShape*) *k;
    its1->SetRnrSelf(kTRUE);
    its1->SetMainColor(1);
    its1->SetMainTransparency(80);
    k++;

    TEveGeoShape* its2 = (TEveGeoShape*) *k;
    its2->SetRnrSelf(kTRUE);
    its2->SetMainColor(1);
    its2->SetMainTransparency(80);
    k++;

    TEveGeoShape* its3 = (TEveGeoShape*) *k;
    its3->SetRnrSelf(kTRUE);
    its3->SetMainColor(1);
    its3->SetMainTransparency(80);

    //TPC

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    j = lvl1->BeginChildren();

    lvl2 = (TEveGeoShape*) *j;
    lvl2->SetRnrSelf(kFALSE);
    k = lvl2->BeginChildren();

    TEveGeoShape* lvl3 = (TEveGeoShape*) *k;
    lvl3->SetRnrSelf(kFALSE);
    lvl3->SetMainColor(1);
    lvl3->SetMainTransparency(80);

    TEveElement::List_i l = lvl3->BeginChildren();

    TEveGeoShape* lvl4 = (TEveGeoShape*) *l;
    lvl4->SetRnrSelf(kFALSE);
    TEveElement::List_i m = lvl4->BeginChildren();

    TEveGeoShape* tpc1 = (TEveGeoShape*) *m;
    tpc1->SetRnrSelf(kTRUE);
    tpc1->SetMainColor(1);
    tpc1->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc2 = (TEveGeoShape*) *m;
    tpc2->SetRnrSelf(kTRUE);
    tpc2->SetMainColor(1);
    tpc2->SetMainTransparency(80);
    m++;

    TEveGeoShape* tpc3 = (TEveGeoShape*) *m;
    tpc3->SetRnrSelf(kTRUE);
    tpc3->SetMainColor(1);
    tpc3->SetMainTransparency(80);
    m++;

    //TRD+TOF

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    j = lvl1->BeginChildren();

    TEveGeoShape* trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainColor(1);
    trd1->SetMainTransparency(80);
    j++;

    TEveGeoShape* tof1 = (TEveGeoShape*) *j;
    tof1->SetRnrSelf(kTRUE);
    tof1->SetMainColor(1);
    tof1->SetMainTransparency(80);

    //PHOS

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)
      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kTRUE);
	lvl2->SetMainColor(1);
	lvl2->SetMainTransparency(80);
      }

    //HMPID

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);

    for(j = lvl1->BeginChildren(); j != lvl1->EndChildren(); ++j)
      {
	lvl2 = (TEveGeoShape*) *j;
	lvl2->SetRnrSelf(kTRUE);
	lvl2->SetMainColor(1);
	lvl2->SetMainTransparency(20);
      }


    gEve->AddGlobalElement(gentle_geom);

    gMultiView->SetDepth(-10);
    gMultiView->DestroyGeomRPhi();
    gMultiView->ImportGeomRPhi(gentle_geom);
    gMultiView->DestroyGeomRhoZ();
    gMultiView->ImportGeomRhoZ(gentle_geom);
    gMultiView->SetDepth(0);

    gMultiView->SetRPhiAxes();
    gMultiView->SetRhoZAxes();


  }

  void ChangeGeometry(){

    if(fGeometrySet)
      {
	DestroyGeometry();
	fGeometrySet = kFALSE;
      }
    else
      {
	GeometryDefault();
	fGeometrySet = kTRUE;
      }

  }

  void ChangeBackgroundColor(){
      
    gEve->GetViewers()->SwitchColorSet();

  }

  void AttachEvent()
  {
    // Attach event data from current directory.

    fVSD->LoadTrees();
    fVSD->SetBranchAddresses();
  }

  void DropEvent()
  {
    // Drup currently held event data, release current directory.

    // Drop old visualization structures.

    gEve->GetViewers()->DeleteAnnotations();
    gEve->GetCurrentEvent()->DestroyElements();

    // Drop old event-data.

    fVSD->DeleteTrees();
    delete fDirectory;
    fDirectory = 0;
  }

  //---------------------------------------------------------------------------
  // Event navigation
  //---------------------------------------------------------------------------

  void NextEvent()
  {
    if(fCurEv == fMaxEv-1)
      GotoEvent(0);
    else
      GotoEvent(fCurEv + 1);

  }

  void PrevEvent()
  {
    if(fCurEv == 0)
      GotoEvent(fMaxEv-1);
    else
      GotoEvent(fCurEv - 1);

  }

  void LoadEvent(Int_t ev)
  {

    DropEvent();

    // Connect to new event-data.

    fCurEv = ev;
    fDirectory = (TDirectory*) ((TKey*) fEvDirKeys->At(fCurEv))->ReadObj();

    //      if(fVSD && fDirectory)
    fVSD->SetDirectory(fDirectory);

    AttachEvent();

  }

  Bool_t GotoEvent(Int_t ev)
  {
      
    change = kTRUE;

    if (ev < 0 || ev >= fMaxEv)
      {
	Warning("GotoEvent", "Invalid event id %d.", ev);
	return kFALSE;
      }

    if(fTimer)
      fTimer->Stop();

    if(fRAnim)
      fRAnim=0;

    DropEvent();
    // Connect to new event-data.

    fCurEv = ev;
    fDirectory = (TDirectory*) ((TKey*) fEvDirKeys->At(fCurEv))->ReadObj();

    if(fVSD && fDirectory)
      fVSD->SetDirectory(fDirectory);

    AttachEvent();

    if(gEventNumber)
      gEventNumber->SetText(TString::Format("%i / %i",fCurEv+1,fMaxEv));

    // Load event data into visualization structures.
    if(fVertexLoaded)
      LoadVertex();

    if(fGuidesLoaded)
      LoadGuides();

    if(fITSClustersLoaded)
      LoadClusters(fITSClusters, "ITS", 0);

    if(fTPCClustersLoaded)
      LoadClusters(fTPCClusters, "TPC", 1);

    if(fTRDClustersLoaded)
      LoadClusters(fTRDClusters, "TRD", 2);

    if(fTOFClustersLoaded)
      LoadClusters(fTOFClusters, "TOF", 3);

    if(fEsdTracksLoaded)
      LoadEsdTracks(fMaxR);

    if(overlayButton && gMultiView)
      gMultiView->Get3DView()->GetGLViewer()->RemoveOverlayElement((TGLOverlayElement*)overlayButton);

    if(globalMode == 1 && gMultiView)
      {

	overlayButton = new TGLOverlayButton(gMultiView->Get3DView()->GetGLViewer(),  "", 0, 0, 200, 30);

	if(gEventNumber->GetText()->GetString() == TString::Format("1"))
	  overlayButton->SetText("Kaon");

	if(gEventNumber->GetText()->GetString() == TString::Format("2"))
	  overlayButton->SetText("Lambda");

	if(gEventNumber->GetText()->GetString() == TString::Format("3"))
	  overlayButton->SetText("antiLambda");

	if(gEventNumber->GetText()->GetString() == TString::Format("4"))
	  overlayButton->SetText("Xi");

//	overlayButton->SetAlphaValues(0.1, 0.8);
      }

    if(gMultiView)
      {
	obutton1->SetPosition(0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-25);
	obutton2->SetPosition(0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-45);
	obutton3->SetPosition(0, gMultiView->Get3DView()->GetEveFrame()->GetHeight()-65);
      }

    TEveElement* top = gEve->GetCurrentEvent();

    if(gMultiView)
      {
	gMultiView->DestroyEventRPhi();
	gMultiView->ImportEventRPhi(top);

	gMultiView->DestroyEventRhoZ();
	gMultiView->ImportEventRhoZ(top);

	gEve->Redraw3D(kFALSE, kTRUE);
      }

    return kTRUE;

  }

  //---------------------------------------------------------------------------
  // Display Clusters and Tracks
  //---------------------------------------------------------------------------

  void Message()
  {
    printf("done.\n");
  }

  void DisplayGuides(){

    if(fGuidesLoaded)
      {
	fGuidesLoaded = kFALSE;
	GotoEvent(fCurEv);
      }
    else
      {
	fGuidesLoaded = kTRUE;
	GotoEvent(fCurEv);
      }

  }

  void DisplayVertex()
  {

    if(fVertexLoaded)
      {

	fVertexLoaded=kFALSE;
	GotoEvent(fCurEv);
	gCheckVertex->SetDisabledAndSelected(kFALSE);
      }

    else
      {

	fVertexLoaded=kTRUE;
	printf("Loading Vertex...\n");
	GotoEvent(fCurEv);
	printf("Vertex loaded.\n");
	gCheckVertex->SetDisabledAndSelected(kTRUE);
         
      }

  }

  void DisplayClusters()
  {

    if(fClustersLoaded)
      {

	fClustersLoaded = kFALSE;
	fITSClustersLoaded=kFALSE;
	fTPCClustersLoaded=kFALSE;
	fTRDClustersLoaded=kFALSE;
	fTOFClustersLoaded=kFALSE;
	GotoEvent(fCurEv);
	gCheckClusters->SetDisabledAndSelected(kFALSE);
      }

    else
      {
	fClustersLoaded = kTRUE;
	fITSClustersLoaded=kTRUE;
	fTPCClustersLoaded=kTRUE;
	fTRDClustersLoaded=kTRUE;
	fTOFClustersLoaded=kTRUE;
	printf("Loading Clusters...\n");
	GotoEvent(fCurEv);
	printf("Clusters loaded.\n");
	gCheckClusters->SetDisabledAndSelected(kTRUE);
      }

  }

  void DisplayITSClusters()
  {


    if(fITSClustersLoaded)
      {

	fITSClustersLoaded=kFALSE;
	GotoEvent(fCurEv);
	gCheckITSClusters->SetDisabledAndSelected(kFALSE);

      }

    else
      {

	fITSClustersLoaded=kTRUE;
	printf("Loading ITS Clusters...\n");
	GotoEvent(fCurEv);
	printf("ITS Clusters loaded.\n");
	gCheckITSClusters->SetDisabledAndSelected(kTRUE);
      }

  }

  void DisplayTPCClusters()
  {

    if(fTPCClustersLoaded)
      {

	fTPCClustersLoaded=kFALSE;
	GotoEvent(fCurEv);
	gCheckTPCClusters->SetDisabledAndSelected(kFALSE);

      }

    else
      {

  
	fTPCClustersLoaded=kTRUE;
	printf("Loading TPC Clusters...\n");
	GotoEvent(fCurEv);
	printf("TPC Clusters loaded.\n");
	gCheckTPCClusters->SetDisabledAndSelected(kTRUE);
         
      }

  }

  void DisplayTRDClusters()
  {

    if(fTRDClustersLoaded)
      {

	fTRDClustersLoaded=kFALSE;
	GotoEvent(fCurEv);
	gCheckTRDClusters->SetDisabledAndSelected(kFALSE);
      }

    else
      {

	fTRDClustersLoaded=kTRUE;
	printf("Loading TRD Clusters...\n");
	GotoEvent(fCurEv);
	printf("TRD Clusters loaded.\n");
	gCheckTRDClusters->SetDisabledAndSelected(kTRUE);         
      }

  }

  void DisplayTOFClusters()
  {

    if(fTOFClustersLoaded)
      {

	fTOFClustersLoaded=kFALSE;
	GotoEvent(fCurEv);

	gCheckTOFClusters->SetDisabledAndSelected(kFALSE);
      }

    else
      {

	fTOFClustersLoaded=kTRUE;
	printf("Loading TOF Clusters...\n");
	GotoEvent(fCurEv);
	printf("TOF Clusters loaded.\n");
         
	gCheckTOFClusters->SetDisabledAndSelected(kTRUE);
      }

  }

  void DisplayEsdTracks()
  {

    if(fEsdTracksLoaded)
      {

	fEsdTracksLoaded=kFALSE;
	GotoEvent(fCurEv);

	if(gCheckESDTracks)
	  gCheckESDTracks->SetDisabledAndSelected(kFALSE);
      }

    else
      {

	fEsdTracksLoaded=kTRUE;
	printf("Loading Esd Tracks...\n");
	GotoEvent(fCurEv);
	printf("Esd Tracks loaded.\n");
	gCheckESDTracks->SetDisabledAndSelected(kTRUE);
         
      }

  }

  //---------------------------------------------------------------------------
  // Tracks animating
  //---------------------------------------------------------------------------

  void AnimateEsdTracks()
  {

    TEveTrackPropagator* trkProp = fTrackList->GetPropagator();
    trkProp->SetMaxR(fRAnim); //R[cm] 

    fRAnim+=10;

    gEve->AddElement(fTrackList);

    TEveElement* top = gEve->GetCurrentEvent();

    gMultiView->DestroyEventRPhi();
    gMultiView->ImportEventRPhi(top);

    gMultiView->DestroyEventRhoZ();
    gMultiView->ImportEventRhoZ(top);

    gEve->Redraw3D(kFALSE, kTRUE);

    if(fRAnim>fMaxR)
      fTimer->Stop();

  }

  void StartAnimation()
  {

    if(fVertexLoaded)
      {
	fVertexLoaded=kFALSE;
	gCheckVertex->SetDisabledAndSelected(kFALSE);
      }

    if(fClustersLoaded)
      {
	fClustersLoaded=kFALSE;
	gCheckClusters->SetDisabledAndSelected(kFALSE);
      }

    if(fITSClustersLoaded)
      {
	fITSClustersLoaded=kFALSE;
      }

    if(fTPCClustersLoaded)
      {
	fTPCClustersLoaded=kFALSE;
      }

    if(fTRDClustersLoaded)
      {
	fTRDClustersLoaded=kFALSE;
      }

    if(fTOFClustersLoaded)
      {
	fTOFClustersLoaded=kFALSE;
      }

    if(fEsdTracksLoaded)
      {
	fEsdTracksLoaded=kFALSE;
        if(gCheckESDTracks)
	  gCheckESDTracks->SetDisabledAndSelected(kFALSE);
      }

    if(fGeometrySet)
      {
	fGeometrySet=kFALSE;
	DestroyGeometry();
      }

//    GotoEvent(fCurEv);

    if(fEsdTracksLoaded)
      {
	fEsdTracksLoaded=kFALSE;
	GotoEvent(fCurEv);
      }
    else
      {
	LoadEsdTracks(fMaxR);
	fEsdTracksLoaded=kTRUE;
      }  

    fTimer->Start(10,kFALSE);

  }

  void StopAnimation()
  {

    fTimer->Stop();

  }

  //---------------------------------------------------------------------------
  // Guides
  //---------------------------------------------------------------------------

  void LoadGuides()
  {

    for(Int_t i=0; i<12; i++)
      {
	guideX[i] = new TEveLine(" ");
	guideX[i]->SetLineColor(kRed);
	guideX[i]->SetLineWidth(1);
	guideX[i]->SetLineStyle(1);
      }

    for(Int_t i=0; i<14; i++)
      {
	guideY[i] = new TEveLine(" ");
	guideY[i]->SetLineColor(kGreen);
	guideY[i]->SetLineWidth(1);
	guideY[i]->SetLineStyle(1);

	guideZ[i] = new TEveLine(" ");
	guideZ[i]->SetLineColor(kBlue);
	guideZ[i]->SetLineWidth(1);
	guideZ[i]->SetLineStyle(1);
      }

    //line X

    guideX[0]->SetPoint(0, -100,  0,  0);
    guideX[0]->SetPoint(1,  100,  0,  0);

    //arrows X
    guideX[1]->SetPoint(0, -100,  0,  0);
    guideX[1]->SetPoint(1, -95,  5,  0);

    guideX[2]->SetPoint(0, -100,  0,  0);
    guideX[2]->SetPoint(1, -95, -5,  0);

    guideX[3]->SetPoint(0,  100,  0,  0);
    guideX[3]->SetPoint(1,  95,  5,  0);

    guideX[4]->SetPoint(0,  100,  0,  0);
    guideX[4]->SetPoint(1,  95, -5,  0);

    //+X
    guideX[5]->SetPoint(0, 95,  10,  0);
    guideX[5]->SetPoint(1, 90,  10,  0);

    guideX[6]->SetPoint(0, 92.5,  7.5,  0);
    guideX[6]->SetPoint(1, 92.5, 12.5,  0);

    guideX[7]->SetPoint(0,  90,  6,  0);
    guideX[7]->SetPoint(1,  86,  14,  0);

    guideX[8]->SetPoint(0,  90,  14,  0);
    guideX[8]->SetPoint(1,  86, 6,  0);

    //-X
    guideX[9]->SetPoint(0, -85,  10,  0);
    guideX[9]->SetPoint(1, -90,  10,  0);

    guideX[10]->SetPoint(0,  -95,  6,  0);
    guideX[10]->SetPoint(1,  -91,  14,  0);

    guideX[11]->SetPoint(0,  -95,  14,  0);
    guideX[11]->SetPoint(1,  -91, 6,  0);

    //line Y
    guideY[0]->SetPoint(0,  0, -100,  0);
    guideY[0]->SetPoint(1,  0,  100,  0);

    //arrows Y
    guideY[1]->SetPoint(0,  0, -100,  0);
    guideY[1]->SetPoint(1,  0, -95,  5);

    guideY[2]->SetPoint(0,  0, -100,  0);
    guideY[2]->SetPoint(1,  0, -95, -5);

    guideY[3]->SetPoint(0,  0,  100,  0);
    guideY[3]->SetPoint(1,  0,  95,  5);

    guideY[4]->SetPoint(0,  0,  100,  0);
    guideY[4]->SetPoint(1,  0,  95, -5);

    //+Y
    guideY[5]->SetPoint(0, 0, 95,  10);
    guideY[5]->SetPoint(1, 0, 90,  10);

    guideY[6]->SetPoint(0, 0, 92.5,  7.5);
    guideY[6]->SetPoint(1, 0, 92.5, 12.5);

    guideY[7]->SetPoint(0,  0, 96.5,  12.5);
    guideY[7]->SetPoint(1,  0, 92.5,  14.5);

    guideY[8]->SetPoint(0,  0, 96.5,  16.5);
    guideY[8]->SetPoint(1,  0, 92.5, 14.5);

    guideY[9]->SetPoint(0,  0, 92.5,  14.5);
    guideY[9]->SetPoint(1,  0, 88.5, 14.5);


    //-Y
    guideY[10]->SetPoint(0, 0, -92.5,  7.5);
    guideY[10]->SetPoint(1, 0, -92.5, 12.5);

    guideY[11]->SetPoint(0,  0, -88.5,  12.5);
    guideY[11]->SetPoint(1,  0, -92.5,  14.5);

    guideY[12]->SetPoint(0,  0, -88.5,  16.5);
    guideY[12]->SetPoint(1,  0, -92.5, 14.5);

    guideY[13]->SetPoint(0,  0, -92.5,  14.5);
    guideY[13]->SetPoint(1,  0, -96.5, 14.5);

    //line Z
    guideZ[0]->SetPoint(0,  0,  0, -100);
    guideZ[0]->SetPoint(1,  0,  0,  100);

    //Z arrows
    guideZ[1]->SetPoint(0,  0,  0, -100);
    guideZ[1]->SetPoint(1,  8,  0, -92);

    guideZ[2]->SetPoint(0,  0,  0, -100);
    guideZ[2]->SetPoint(1, -8,  0, -92);

    guideZ[3]->SetPoint(0,  0,  0,  100);
    guideZ[3]->SetPoint(1,  8,  0,  92);

    guideZ[4]->SetPoint(0,  0,  0,  100);
    guideZ[4]->SetPoint(1, -8,  0,  92);

    //+Z
    guideZ[5]->SetPoint(0, 0, 10, 90);
    guideZ[5]->SetPoint(1, 0, 10, 85);

    guideZ[6]->SetPoint(0, 0, 7.5, 87.5);
    guideZ[6]->SetPoint(1, 0, 12.5, 87.5);

    guideZ[7]->SetPoint(0,  0, 14, 95);
    guideZ[7]->SetPoint(1,  0, 14, 90);

    guideZ[8]->SetPoint(0,  0, 14, 95);
    guideZ[8]->SetPoint(1,  0, 6, 90);

    guideZ[9]->SetPoint(0,  0, 6, 90);
    guideZ[9]->SetPoint(1,  0, 6, 95);

    //-Z
    guideZ[10]->SetPoint(0, 0, 10, -90);
    guideZ[10]->SetPoint(1, 0, 10, -95);

    guideZ[11]->SetPoint(0,  0, 14, -90);
    guideZ[11]->SetPoint(1,  0, 14, -85);

    guideZ[12]->SetPoint(0,  0, 14, -85);
    guideZ[12]->SetPoint(1,  0, 6, -90);

    guideZ[13]->SetPoint(0,  0, 6, -85);
    guideZ[13]->SetPoint(1,  0, 6, -90);

    for(Int_t i=0; i<12; i++)
      {
	gEve->AddElement(guideX[i]);
      }

    for(Int_t i=0; i<14; i++)
      {
	gEve->AddElement(guideY[i]);
	gEve->AddElement(guideZ[i]);
      }


  }

  //---------------------------------------------------------------------------
  // Primary Vertex
  //---------------------------------------------------------------------------

  void LoadVertex()
  {
    if (fPsVertex == 0)
      {
	fPsVertex = new TEvePointSet("Vertex");
	fPsVertex->SetMainColor(14);
	fPsVertex->SetMarkerSize(2);
	fPsVertex->SetMarkerStyle(2);
	fPsVertex->IncDenyDestroy();
      }
    else
      {
	fPsVertex->Reset();
      }

    TEvePointSelector ss(fVSD->fTreeH, fPsVertex, "fV.fX:fV.fY:fV.fZ");
    ss.Select();

    fPsVertex->SetTitle("Primary Vertex");

    gEve->AddElement(fPsVertex);

    TEveLine* PointingLine = new TEveLine(TString::Format(" "));
    PointingLine->SetPoint(0, 0, 0, 0);
    PointingLine->SetPoint(1, 0, 0, 0);
    PointingLine->SetLineColor(0);
    PointingLine->SetLineWidth(0);
    PointingLine->SetLineStyle(0);
    gEve->AddElement(PointingLine);



  }

  //---------------------------------------------------------------------------
  // Cluster loading
  //---------------------------------------------------------------------------

  void LoadClusters(TEvePointSet*& ps, const TString& det_name, Int_t det_id)
  {
    if (ps == 0)
      {
	ps = new TEvePointSet(det_name);

	ps->SetMainColor((Color_t)(det_id + 4));
	ps->SetMarkerSize(0.5);
	ps->SetMarkerStyle(2);
	ps->IncDenyDestroy();
      }
    else
      {
	ps->Reset();
      }

    TEvePointSelector ss(fVSD->fTreeC, ps, "fV.fX:fV.fY:fV.fZ",
			 TString::Format("fDetId==%d", det_id));
    ss.Select();
    ps->SetTitle(det_name + " Clusters");

    gEve->AddElement(ps);

  }

  //---------------------------------------------------------------------------
  // Track loading
  //---------------------------------------------------------------------------

  enum ESDTrackFlags
    {
      kITSin=0x0001,kITSout=0x0002,kITSrefit=0x0004,kITSpid=0x0008,
      kTPCin=0x0010,kTPCout=0x0020,kTPCrefit=0x0040,kTPCpid=0x0080,
      kTRDin=0x0100,kTRDout=0x0200,kTRDrefit=0x0400,kTRDpid=0x0800,
      kTOFin=0x1000,kTOFout=0x2000,kTOFrefit=0x4000,kTOFpid=0x8000,
      kHMPIDpid=0x20000,
      kEMCALmatch=0x40000,
      kTRDbackup=0x80000,
      kTRDStop=0x20000000,
      kESDpid=0x40000000,
      kTIME=0x80000000
    };

  Bool_t trackIsOn(TEveTrack* t, Int_t mask)
  {
    // Check is track-flag specified by mask are set.

    return (t->GetStatus() & mask) > 0;
  }

  void LoadEsdTracks(Int_t maxR)
  {
    // Read reconstructed tracks from current event.

    if (fTrackList == 0)
      {
	fTrackList = new TEveTrackList("ESD Tracks"); 
	fTrackList->SetMainColor(40);
	fTrackList->SetMarkerColor(kYellow);
	fTrackList->SetMarkerStyle(4);
	fTrackList->SetMarkerSize(0.5);

	fTrackList->IncDenyDestroy();
      }
    else
      {
	fTrackList->DestroyElements();
      }

    TEveTrackPropagator* trkProp = fTrackList->GetPropagator();
    trkProp->SetMagField(0.5);
    trkProp->SetMaxR(maxR); //R[cm]

    Int_t nTracks = fVSD->fTreeR->GetEntries();

    fVSD->fTreeR->GetEntry(0);
    Int_t nCascades = fVSD->fR.fIndex;

    nCascadeTracks = nCascades;

    Int_t n = 0;

    for (Int_t i = nCascades; i < nTracks; ++i)
      {
	fVSD->fTreeR->GetEntry(n);
	TEveTrack* track = new TEveTrack(&fVSD->fR, trkProp);
	track->SetName("ESD_Track");
	track->SetTitle("ESD_Track");
	track->SetAttLineAttMarker(fTrackList);
	fTrackList->AddElement(track);
/*
        printf("%d\n",track->GetStatus());
        kElectron = 0, 
        kMuon = 1, 
        kPion = 2, 
        kKaon = 3, 
        kProton = 4
*/
	n++;

      }

    fTrackList->MakeTracks();
    gEve->AddElement(fTrackList);

  }

  void LoadV0s()
  {

    if(fVSD->fTreeV0)
      {

	TEveRecTrack  rcPos;
	TEveRecTrack  rcNeg;
	TEveRecTrack  rcMother;
	TEveRecTrack  rcPointing;
	Int_t pdg;
	Double_t massN, massP, momentum;

	if (fTrackListV0Neg == 0)
	  {
	    fTrackListV0Neg = new TEveTrackList("V0 Tracks Neg"); 
	    fTrackListV0Neg->SetMainColor(kGreen-4);
	    fTrackListV0Neg->SetMarkerColor(kYellow);
	    fTrackListV0Neg->SetMarkerStyle(10);

	    fTrackListV0Neg->SetMarkerSize(5);

	    fTrackListV0Neg->IncDenyDestroy();
	  }
	else
	  {
	    fTrackListV0Neg->DestroyElements();
	  }

	if (fTrackListV0Pos == 0)
	  {
	    fTrackListV0Pos = new TEveTrackList("V0 Tracks Pos"); 
	    fTrackListV0Pos->SetMainColor(2);
	    fTrackListV0Pos->SetMarkerColor(kYellow);
	    fTrackListV0Pos->SetMarkerStyle(10);
	    fTrackListV0Pos->SetMarkerSize(5);

	    fTrackListV0Pos->IncDenyDestroy();
	  }
	else
	  {
	    fTrackListV0Pos->DestroyElements();
	  }

	if (fTrackListV0Mother == 0)
	  {
	    fTrackListV0Mother = new TEveTrackList("V0 Mother Tracks"); 
	    fTrackListV0Mother->SetMainColor(kSpring+6);
	    fTrackListV0Mother->SetMarkerColor(kSpring+6);
	    fTrackListV0Mother->SetMarkerStyle(10);
	    fTrackListV0Mother->SetMarkerSize(5);

	    fTrackListV0Mother->IncDenyDestroy();
	  }
	else
	  {
	    fTrackListV0Mother->DestroyElements();
	  }

	if (fPsV0 == 0)
	  {
	    fPsV0 = new TEvePointSet();
	    fPsV0->SetMainColor(14);
	    fPsV0->SetMarkerSize(0.5);
	    fPsV0->SetMarkerStyle(2);
	    fPsV0->IncDenyDestroy();
	  }
	else
	  {
	    fPsV0->Reset();
	  }

	TEveTrackPropagator* trkProp = fTrackListV0Neg->GetPropagator();
	trkProp->SetMagField(0.5);
	trkProp->SetMaxR(600); //R[cm]

	TEveTrackPropagator* trkProp2 = fTrackListV0Mother->GetPropagator();
	trkProp2->SetMagField(0.5);

	Int_t nV0s = fVSD->fTreeV0->GetEntries();
	nV0Tracks = nV0s;

	fVSD->fTreeR->GetEntry(0);
	Int_t nCascades = fVSD->fR.fIndex;//fVSD->fTreeR->GetEntry(0);001-0.985750-4.389611

	nCascadeTracks = nCascades;

	Int_t n = 0;

	TEvePointSelector ss(fVSD->fTreeV0, fPsV0, "fVCa.fX:fVCa.fY:fVCa.fZ");
	ss.Select();
	fPsV0->SetTitle("V0_CA_Points");

	for(Int_t i=nCascades; i<nV0s; i++)
	  {

	    fVSD->fTreeV0->GetEntry(n);

	    pdg = fVSD->fV0.fPdg;

	    switch (pdg)
	      {
	      case 0:
		massN = gMassElecton;
		massP = gMassElecton;
		break;
	      case 310:
		massN = gMassPion;
		massP = gMassPion;
		break;
	      case 3122:
		massN = gMassPion;
		massP = gMassProton;
		break;
	      case -3122:
		massN = gMassProton;
		massP = gMassPion;
		break;
	      default:
		massN = gMassPion;
		massP = gMassPion;
		break;
	      }

	    rcNeg.fP.Set(fVSD->fV0.fPNeg);
	    rcNeg.fV.Set(fVSD->fV0.fVNeg);
	    rcNeg.fStatus = fVSD->fV0.fStatus;
	    rcNeg.fLabel = fVSD->fV0.fDLabel[0];
	    momentum = fVSD->fV0.fPNeg.Mag();
	    rcNeg.fBeta = momentum/TMath::Sqrt(momentum*momentum + TMath::C()*TMath::C()*massN*massN);
	    rcNeg.fSign = -1;

	    rcPos.fP.Set(fVSD->fV0.fPPos);
	    rcPos.fV.Set(fVSD->fV0.fVPos);
	    rcPos.fStatus = fVSD->fV0.fStatus;
	    rcPos.fLabel = fVSD->fV0.fDLabel[1];
	    momentum = fVSD->fV0.fPPos.Mag();
	    rcPos.fBeta = momentum/TMath::Sqrt(momentum*momentum + TMath::C()*TMath::C()*massP*massP);
	    rcPos.fSign = 1;

	    TEveTrack* track1 = new TEveTrack(&rcNeg, trkProp);
	    track1->SetName(TString::Format("V0_Track_Neg_%d", n));
	    track1->SetAttLineAttMarker(fTrackListV0Neg);

	    pxNeg[n]=track1->GetMomentum().fX;
	    pyNeg[n]=track1->GetMomentum().fY;
	    pzNeg[n]=track1->GetMomentum().fZ;
	    
	    
	    massNegCas[n]=massN;
	    

	    TEveTrack* track2 = new TEveTrack(&rcPos, trkProp);
	    track2->SetName(TString::Format("V0_Track_Pos_%d", n));
	    track2->SetAttLineAttMarker(fTrackListV0Pos);

	    pxPos[n]=track2->GetMomentum().fX;
	    pyPos[n]=track2->GetMomentum().fY;
	    pzPos[n]=track2->GetMomentum().fZ;
	    massPos[n]=massP;

	    pcaX[n] = fVSD->fV0.fVCa.fX;
	    pcaY[n] = fVSD->fV0.fVCa.fY;
	    pcaZ[n] = fVSD->fV0.fVCa.fZ;

	    momentum = TMath::Sqrt((pxNeg[n]+pxPos[n])*(pxNeg[n]+pxPos[n])
					    +(pyNeg[n]+pyPos[n])*(pyNeg[n]+pyPos[n])+(pyNeg[n]+pyPos[n])*(pyNeg[n]+pyPos[n]));
	    Double_t direction[3] = {(pxNeg[n]+pxPos[n])/momentum, (pyNeg[n]+pyPos[n])/momentum, (pzNeg[n]+pzPos[n])/momentum};

	    pointingLine[n] = new TEveLine(TString::Format("V0_Pointing_Line_%d", n));
	    pointingLine[n]->SetPoint(0, 0.0, pcaY[n]-pcaX[n]*direction[1]/direction[0], pcaZ[n]-pcaX[n]*direction[2]/direction[0]);
	    pointingLine[n]->SetPoint(1, pcaX[n], pcaY[n], pcaZ[n]);
	    pointingLine[n]->SetLineColor(kSpring+6);
	    pointingLine[n]->SetLineWidth(2);
	    pointingLine[n]->SetLineStyle(2);
	    gEve->AddElement(pointingLine[n]);

	    fTrackListV0Pos->AddElement(track2);
	    fTrackListV0Neg->AddElement(track1);

	    n++;

	  }

	fTrackListV0Pos->MakeTracks();
	fTrackListV0Neg->MakeTracks();

	gEve->AddElement(fPsV0);
	gEve->AddElement(fTrackListV0Pos);
	gEve->AddElement(fTrackListV0Neg);

	TEveElement* top = gEve->GetCurrentEvent();

	if(gMultiView)
	  {
	    gMultiView->DestroyEventRPhi();
	    gMultiView->ImportEventRPhi(top);

	    gMultiView->DestroyEventRhoZ();
	    gMultiView->ImportEventRhoZ(top);
	  }

	gEve->Redraw3D(kFALSE, kTRUE);

      }

  }

  ClassDef(TVSDReader, 0);
};

TVSDReader* gVSDReader = 0;


// Forward declaration.
//void make_gui(Int_t mode);

//______________________________________________________________________________
void alice_vsd(Int_t choice, Int_t mode, Int_t dataset, TString name1, TString name2)
{

  const char* vsd_file_name = NULL;

  globalName1 = name1;
  globalName2 = name2;

    switch(dataset)
    {

    case 1:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_1.root";
      break;

    case 2:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_2.root";
      break;

    case 3:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_3.root";
      break;

    case 4:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_4.root";
      break;

    case 5:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_5.root";
      break;

    case 6:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_6.root";
      break;

    case 7:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_7.root";
      break;

    case 8:
      vsd_file_name = "eve_files/data/AliVSD_MasterClass_8.root";
      break;

    }


 // vsd_file_name = "AliVSD.root";

  globalChoice = choice;
  globalMode = mode;
  globalDataset = dataset;

  // Main function, initializes the application.
  //
  // 1. Load the auto-generated library holding ESD classes and ESD dictionaries.
  // 2. Open ESD data-files.
  // 3. Load cartoon geometry.
  // 4. Spawn simple GUI.
  // 5. Load first event.

  TFile::SetCacheFileDir(".");

  TEveVSD::DisableTObjectStreamersForVSDStruct();

  TEveManager::Create(kTRUE,"FV");

  TEveGeoShape *gentle_geom = 0;
    TFile* geom = TFile::Open("alice_mini_geom.root");
    if (!geom)
      return;
    TEveGeoShapeExtract* gse = (TEveGeoShapeExtract*) geom->Get("Gentle");
    gentle_geom = TEveGeoShape::ImportShapeExtract(gse, 0);
    geom->Close();
    delete geom;

    gentle_geom->SetRnrSelf(kFALSE);

    //ITS

    TEveElement::List_i i = gentle_geom->BeginChildren();

    TEveGeoShape* lvl1 = (TEveGeoShape*) *i;

    //TPC

    i++;

    //TRD+TOF

    i++;

    lvl1 = (TEveGeoShape*) *i;
    lvl1->SetRnrSelf(kFALSE);
    TEveElement::List_i j = lvl1->BeginChildren();

    TEveGeoShape* trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    j++;
    j++;
    j++;
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    j++;
    j++;
    j++;
    j++;
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;

    trd1 = (TEveGeoShape*) *j;
    trd1->SetRnrSelf(kTRUE);
    trd1->SetMainTransparency(80);
    j++;


  gEve->AddGlobalElement(gentle_geom);

  // Standard multi-view
  //=====================

  gMultiView = new MultiView();
  gMultiView->f3DView->GetGLViewer()->SetStyle(TGLRnrCtx::kOutline);
  gMultiView->f3DView->GetGLViewer()->SetStyle(0);
  gMultiView->SetDepth(-10);
  gMultiView->ImportGeomRPhi(gentle_geom);
  gMultiView->ImportGeomRhoZ(gentle_geom);
  gMultiView->SetDepth(0);

  // Final stuff
  //=============

  gEve->GetViewers()->SwitchColorSet();
  gEve->GetDefaultGLViewer()->SetStyle(TGLRnrCtx::kOutline);

  //   make_gui(mode);

  gVSDReader = new TVSDReader(vsd_file_name);

  gVSDReader->fTimer = new TTimer();
  gVSDReader->fTimer->Connect("Timeout()", "TVSDReader", gVSDReader, "AnimateEsdTracks()");

  TEveBrowser* browser = gEve->GetBrowser();

  browser->GetTabLeft()->RemoveTab(1);
  browser->GetTabLeft()->RemoveTab(0);
 
  //   browser->StartEmbedding(TRootBrowser::kRight);

  gStyle->SetOptStat("e");
//  gStyle->SetOptFit(1111);
  gStyle->SetOptFit(0);
  gStyle->SetCanvasColor(0);
  gStyle->SetPalette(1);

  //   TCanvas* pad = new TCanvas();
  //   pad->Divide(2, 2);

  //   pad->cd(1);
  gKMinvHist = new TH1D("Statistics","Kaons",50,0.0,2.0);
  gKMinvHist->SetLineColor(2);
  gKMinvHist->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
  gKMinvHist->GetYaxis()->SetTitle("Counts");
  gKMinvHist->SetFillColor(0);
  //   gKMinvHist->Draw();

  //   pad->cd(2);
  gXMinvHist = new TH1D("Statistics","Xis",50,0.0,2.0);
  gXMinvHist->SetLineColor(3);
  gXMinvHist->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
  gXMinvHist->GetYaxis()->SetTitle("Counts");
  gXMinvHist->SetFillColor(0);
  //   gXMinvHist->Draw();

  //   pad->cd(3);
  gLMinvHist = new TH1D("Statistics","Lambdas",50,0.0,2.0);
  gLMinvHist->SetLineColor(4);
  gLMinvHist->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
  gLMinvHist->GetYaxis()->SetTitle("Counts");
  gLMinvHist->SetFillColor(0);
  //   gLMinvHist->Draw();

  //   pad->cd(4);
  gALMinvHist = new TH1D("Statistics","Anti-Lambdas",50,0.0,2.0);
  gALMinvHist->SetLineColor(9);
  gALMinvHist->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
  gALMinvHist->GetYaxis()->SetTitle("Counts");
  gALMinvHist->SetFillColor(0);
  //   gALMinvHist->Draw();

  gAllMinvHist = new TH1D("Statistics","Invariant Mass - final result",20,0.0,2.0);
  gAllMinvHist->GetXaxis()->SetTitle("Invariant Mass (GeV/c^{2})");
  gAllMinvHist->GetYaxis()->SetTitle("Counts");
  gAllMinvHist->SetFillColor(0);

  gEve->AddEvent(new TEveEventManager("Event", "ALICE VSD Event"));

  if(mode == 3)
    {
      teacher = kTRUE;
      gVSDReader->ToTeacher();
    }
  else
    {
//      gVSDReader->StudentSet();
      gVSDReader->ToStudent();
      gVSDReader->GotoEvent(0);
    }
  gEve->GetWindowManager()->HideAllEveDecorations();
  gEve->Redraw3D(kTRUE); // Reset camera after the first event has been shown.

}

